<?php
/* Modificar o logo da página de login */
function custom_login_logo() { echo "<style type='text/css'> h1 a { background:url(http://www.viaoceanica.com/logo_88x88px.png)!important; width:89px !important; height:88px !important; } </style>"; }
add_action('login_head', 'custom_login_logo');
/* Remove os logos do Wordpress do backoffice */
add_action ('admin_bar_menu', 'remove_wp_logo', 999);
function remove_wp_logo ($wp_admin_bar) { $wp_admin_bar->remove_node('wp-logo'); }
/* Personaliza o rodapé do backoffice */
function modify_footer() { echo 'Mantido por <a href="http://www.viaoceanica.com" target="_blank">Via Oceânica</a>.Precisa de suporte? <a href="http://www.viaoceanica.com/contactos" target="_blank">Contacte-nos</a>.'; }
add_filter('admin_footer_text', 'modify_footer');

/**
 * vGest functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package vGest
 */

if ( ! function_exists( 'vgest_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function vgest_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on vGest, use a find and replace
		 * to change 'vgest' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'vgest', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
add_filter('vc_grid_get_grid_data_access','__return_true');
		// This theme uses wp_nav_menu() in one location.
		require_once get_template_directory() . '/template-parts/class-wp-bootstrap-navwalker.php';
		function register_my_menus() {
		  register_nav_menus(
		    array(
		      'cab-menu' => __( 'Cabeçalho' ),
		      'rod-menu' => __( 'Rodapé' ),
		      'rod-menu2' => __( 'Rodapé Social' )
		    )
		  );
		}
		add_action( 'init', 'register_my_menus' );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'vgest_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'vgest_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function vgest_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'vgest_content_width', 640 );
}
add_action( 'after_setup_theme', 'vgest_content_width', 0 );

/**js/customizer.js
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function vgest_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'vgest' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'vgest' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'vgest_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function vgest_scripts() {
	wp_enqueue_style( 'vgest-style', get_stylesheet_uri() );

  wp_enqueue_script( 'vgest-bootrap', get_template_directory_uri() . '/js/bootstrap.min.js', array(), '20151215', true );
  wp_enqueue_script( 'vgest-customizer', get_template_directory_uri() . '/js/customizer.js', array(), '20151215', true );
  
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'vgest_scripts' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Esconder títulos das páginas  */
function wpb_hidetitle_class($classes) {
	if ( is_single() || is_page() ) : 
	$classes[] = 'hidetitle';
	return $classes;
	endif; 
	return $classes;
}
add_filter('post_class', 'wpb_hidetitle_class');

/**
 * Mostra os utilizadores aos editores  */
function isa_editor_manage_users() {
  if ( get_option( 'isa_add_cap_editor_once' ) != 'done' ) {
    // let editor manage users
    $edit_editor = get_role('editor'); // Get the user role
    $edit_editor->add_cap('edit_users');
    $edit_editor->add_cap('list_users');
    $edit_editor->add_cap('promote_users');
    $edit_editor->add_cap('create_users');
    $edit_editor->add_cap('add_users');
    $edit_editor->add_cap('delete_users');
    update_option( 'isa_add_cap_editor_once', 'done' );
  }
}
add_action( 'init', 'isa_editor_manage_users' );

/**
 * Evita editores de ver e editar administradores  */
class ISA_User_Caps {
  function __construct() {
    add_filter( 'editable_roles', array(&$this, 'editable_roles'));
    add_filter( 'map_meta_cap', array(&$this, 'map_meta_cap'),10,4);
  }
  function editable_roles( $roles ){
    if( isset( $roles['administrator'] ) && !current_user_can('administrator') ){
      unset( $roles['administrator']);
    }
    return $roles;
  }
  function map_meta_cap( $caps, $cap, $user_id, $args ){
    switch( $cap ){
        case 'edit_user':
        case 'remove_user':
        case 'promote_user':
            if( isset($args[0]) && $args[0] == $user_id )
                break;
            elseif( !isset($args[0]) )
                $caps[] = 'do_not_allow';
            $other = new WP_User( absint($args[0]) );
            if( $other->has_cap( 'administrator' ) ){
                if(!current_user_can('administrator')){
                    $caps[] = 'do_not_allow';
                }
            }
            break;
        case 'delete_user':
        case 'delete_users':
            if( !isset($args[0]) )
                break;
            $other = new WP_User( absint($args[0]) );
            if( $other->has_cap( 'administrator' ) ){
                if(!current_user_can('administrator')){
                    $caps[] = 'do_not_allow';
                }
            }
            break;
        default:
            break;
    }
    return $caps;
  }
 
}
$isa_user_caps = new ISA_User_Caps();

/**
 * Evita editores de ver e editar administradores  */
add_action('pre_user_query','isa_pre_user_query');
function isa_pre_user_query($user_search) {
  $user = wp_get_current_user();
  if ( ! current_user_can( 'manage_options' ) ) {
    global $wpdb;
    $user_search->query_where = str_replace('WHERE 1=1', "WHERE 1=1 AND {$wpdb->users}.ID IN ( SELECT {$wpdb->usermeta}.user_id FROM $wpdb->usermeta WHERE {$wpdb->usermeta}.meta_key = '{$wpdb->prefix}capabilities' AND {$wpdb->usermeta}.meta_value NOT LIKE '%administrator%')", $user_search->query_where );
  }
}
 
/**
 * Paginação  */
/*
 * custom pagination with bootstrap .pagination class
 * source: http://www.ordinarycoder.com/paginate_links-class-ul-li-bootstrap/
 */
function bootstrap_pagination( $echo = true ) {
	global $wp_query;

	$big = 999999999; // need an unlikely integer

	$pages = paginate_links( array(
			'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format' => '?paged=%#%',
			'current' => max( 1, get_query_var('paged') ),
			'total' => $wp_query->max_num_pages,
			'type'  => 'array',
			'prev_next'   => true,
			'prev_text'    => __('« Prev'),
			'next_text'    => __('Next »'),
		)
	);

	if( is_array( $pages ) ) {
		$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');

		$pagination = '<nav aria-label="Page navigation example">';
		$pagination .= '<ul class="pagination justify-content-center">';
		foreach ( $pages as $page ) {
			$pagination .= "<li class='page-item'>$page</li>";
		}
		$pagination .= '</ul>';
		$pagination .= '</nav>';

		if ( $echo ) {
			echo $pagination;
		} else {
			return $pagination;
		}
	}
}

/*
* Define a constant path to our single template folder
*/
define(SINGLE_PATH, TEMPLATEPATH . '/template-parts/single-post');
 
/**
* Filter the single_template with our custom function
*/
add_filter('single_template', 'my_single_template');
 
/**
* Single template function which will choose our template
*/
function my_single_template($single) {
	global $wp_query, $post;
	return SINGLE_PATH . '/index.php';
}
