<?php
  global $wplab_albedo_core;
	/** unique id **/
	$attributes[] = 'id="shortcode-' . esc_attr( $atts['el_id'] ) . '"';
	$attributes[] = 'data-effect="' . esc_attr( $atts['effect'] ) . '"';
	$attributes[] = 'data-pagination="' . esc_attr( $atts['pagination'] ) . '"';
	$attributes[] = 'data-loop="' . esc_attr( $atts['loop'] ) . '"';

	if( filter_var( $atts['autoplay'], FILTER_VALIDATE_BOOLEAN ) ) {
		$attributes[] = 'data-autoplay="' . esc_attr( $atts['autoplay_speed'] ) . '"';
		$attributes[] = 'data-autoplay-stop-on-last="' . esc_attr( $atts['autoplay_stop_on_last'] ) . '"';
		$attributes[] = 'data-autoplay-disable-on-interaction="' . esc_attr( $atts['autoplay_disable_on_interaction'] ) . '"';
	}

	if( $atts['style'] == 'parallax' ) {
		$attributes[] = 'data-parallax="true"';
		$classes[] = 'overlay-color-' . $atts['overlay_color'];
	}

  $terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

  $items = $wplab_albedo_core->model('post')->get( array(
    'post_type' => 'testimonials',
    'type' => $atts['query_type'],
    'posts_per_page' => absint( $atts['posts_per_page'] ),
    'order' => $atts['order_by'],
    'sort' => $atts['sort_by'],
    'tax_name' => 'testimonials_category',
    'term_field' => 'slug',
    'terms' => $terms
  ) );

?>

<div class="shortcode-testimonials style-<?php echo esc_attr( $atts['style'] ); ?> <?php echo implode(' ', $classes); ?>" <?php echo implode( ' ', $attributes ); ?>>
	<!-- Slider main container -->
	<div class="swiper-container">

		<?php if( $atts['style'] == 'parallax' ): ?>
		<?php $parallax_bg = $atts['parallax_bg'] <> '' ? wp_get_attachment_url( $atts['parallax_bg'] ) : ''; ?>
		<!-- parallax bg -->
		<div class="parallax-bg" style="background-image:url(<?php echo esc_attr( $parallax_bg ); ?>);" data-swiper-parallax="-23%"></div>
		<div class="parallax-overlay"></div>
		<?php endif; ?>

    <!-- Additional required wrapper -->
    <div class="swiper-wrapper">

      <?php while ( $items->have_posts() ): $items->the_post(); ?>

        <?php
          $text = get_the_content();
          $author = fw_get_db_post_option( get_the_ID(), 'author' );
          $position = fw_get_db_post_option( get_the_ID(), 'position' );
          $photo = get_the_post_thumbnail_url( get_the_ID(), 'full');
        ?>

        <div class="swiper-slide">
          <div class="slide-content">
            <?php
              /**
               * Default style markup
               **/
            ?>
            <?php if( $atts['style'] == 'default' ): ?>
            <?php
              $photo_width = absint( $atts['photo_width'] );
              $photo_height = absint( $atts['photo_height'] );
            ?>
            <header>
              <?php if( $photo <> '' ): ?>
              <div class="photo">
                <?php echo wplab_albedo_media::image( $photo, $photo_width, $photo_height, true, true, $photo ); ?>
              </div>
              <?php endif; ?>
              <div class="header-text">
                <?php if( $author <> '' ): ?>
                <div class="author">
                  <?php echo wp_kses_post( $author ); ?>
                </div>
                <?php endif; ?>
                <?php if( $position <> '' ): ?>
                <div class="position">
                  <?php echo wp_kses_post( $position ); ?>
                </div>
                <?php endif; ?>
              </div>

            </header>

            <?php if( $text <> '' ): ?>
            <div class="text">
              <?php echo wp_kses_post( $text ); ?>
            </div>
            <?php endif; ?>

            <?php
              /**
               * Gradient style / header markup
               **/
            ?>
            <?php elseif( $atts['style'] == 'gradient' ): ?>
            <?php
              $header_bg_src = fw_get_db_post_option( get_the_ID(), 'bg' );
              $header_bg_image = isset( $header_bg_src['url'] ) ? $header_bg_src['url'] : '';
            ?>
            <header style="<?php if( $header_bg_image <> ''): ?>background-image: url(<?php echo $header_bg_image; ?>);<?php endif; ?>">
              <div class="gradient-overlay gradient-<?php echo esc_attr( $atts['gradient_color'] ); ?>"></div>
              <?php if( $text <> '' ): ?>
              <div class="text">
                <?php echo wp_kses_post( $text ); ?>
              </div>
              <?php endif; ?>
              <?php if( $photo <> '' ): ?>
              <div class="photo">
                <?php echo wplab_albedo_media::image( $photo, 80, 80, true, true, $photo ); ?>
              </div>
              <?php endif; ?>
            </header>
            <div class="about-author">
              <?php if( $author <> '' ): ?>
              <div class="author">
                <?php echo wp_kses_post( $author ); ?>
              </div>
              <?php endif; ?>
              <?php if( $position <> '' ): ?>
              <div class="position">
                <?php echo wp_kses_post( $position ); ?>
              </div>
              <?php endif; ?>
            </div>

            <?php
              /**
               * All another styles markup
               **/
            ?>
            <?php else: ?>
              <?php if( $photo <> '' ): ?>
              <div class="content-photo photo">
                <?php echo wplab_albedo_media::image( $photo, 100, 100, true, true, $photo ); ?>
              </div>
              <?php endif; ?>

              <?php if( $text <> '' ): ?>
              <div class="text">
                <?php echo wp_kses_post( $text ); ?>
              </div>
              <?php endif; ?>

              <div class="about-author">
                <?php if( $author <> '' ): ?>
                <div class="author">
                  <?php echo wp_kses_post( $author ); ?>
                </div>
                <?php endif; ?>
                <?php if( $position <> '' ): ?>
                <div class="position">
                  <?php echo wp_kses_post( $position ); ?>
                </div>
                <?php endif; ?>
              </div>

            <?php endif; ?>

          </div>
        </div>

      <?php endwhile; wp_reset_postdata(); ?>

    </div>
	</div>

	<?php if( $atts['pagination'] == 'yes' ): ?>
	  <!-- If we need pagination -->
	  <div class="swiper-pagination"></div>
  <?php endif; ?>

</div>
