<?php
  $parent_atts = WPBakeryShortCode_Albedo_Tabs_Single::$parent_atts;

  if( is_null( $parent_atts ) ) {
    $parent_atts = $_SESSION['albedo_tabs_shortcode_atts'];
  }

  $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
?>
<div class="tab_content" data-tab-title="<?php echo esc_attr( $atts['title'] ); ?>">

  <?php $img_url = wp_get_attachment_url( $atts['tab_image'] ); ?>
  <div class="tab-content-wrapper">
    <?php if( in_array( $parent_atts['style'], array('modern', 'modern_alt') ) && !empty( $atts['tab_image'] ) && $parent_atts['type'] == 'horizontal' ): ?>

    <?php
      $img_width = is_numeric( $atts['image_width'] ) ? $atts['image_width'] : null;
      $img_height = is_numeric( $atts['image_height'] ) ? $atts['image_height'] : null;
    ?>
    <div class="tab-content-image" style="<?php echo is_numeric( $img_width ) ? 'width: ' . $img_width . 'px' : ''; ?>">

      <?php echo wplab_albedo_media::image( $img_url, $img_width, $img_height, true, true, $img_url, true ); ?>

    </div>
    <?php endif; ?>

    <div class="tab-content-text">

      <?php if( filter_var( $parent_atts['display_title'], FILTER_VALIDATE_BOOLEAN ) ): ?>
      <h4 class="title"><?php echo wp_kses_post( $atts['title'] ); ?></h4>
      <?php endif; ?>

      <?php echo wpautop( $content ); ?>

      <?php if( filter_var( $atts['display_button'], FILTER_VALIDATE_BOOLEAN ) ): ?>
        <p>
          <a target="_blank" href="<?php echo esc_attr( $atts['button_url'] ); ?>" class="button style-<?php echo esc_attr( $atts['button_style'] ); ?>"><?php echo wp_kses_post( $atts['button_title'] ); ?></a>
        </p>
      <?php endif; ?>

    </div>

    <?php if( in_array( $parent_atts['style'], array('modern', 'modern_alt') ) && !empty( $atts['tab_image'] ) && $parent_atts['type'] == 'vertical' ): ?>

    <?php
    $img_width = is_numeric( $atts['image_width'] ) ? $atts['image_width'] : null;
    $img_height = is_numeric( $atts['image_width'] ) ? $atts['image_width'] : null;
    ?>
    <div class="tab-content-image" style="<?php echo is_numeric( $img_width ) ? 'width: ' . $img_width . 'px' : ''; ?>">

      <?php echo wplab_albedo_media::image( $img_url, $img_width, $img_height, true, true, $img_url, true ); ?>

    </div>
    <?php endif; ?>

  </div>

</div>
