<?php

if ( $atts['image'] == '' ) {
	return;
}

/** image properties **/
$is_link = filter_var( $atts['add_link'], FILTER_VALIDATE_BOOLEAN ) && $atts['link_url'] <> '';
$is_lightbox = filter_var( $atts['lightbox'], FILTER_VALIDATE_BOOLEAN );

$is_lazy = filter_var( $atts['lazy_load'], FILTER_VALIDATE_BOOLEAN );
$is_hover_effect = filter_var( $atts['hover_effect'], FILTER_VALIDATE_BOOLEAN );

$width = is_numeric( $atts['width'] ) ? $atts['width'] : null;
$height = is_numeric( $atts['height'] ) ? $atts['height'] : null;

/** additional CSS classes **/
$img_classes[] = 'img-shortcode';
$wrapper_attributes[] = 'id="shortcode-' . esc_attr( $atts['el_id'] ) . '"';
$img_attributes[] = 'alt="' . esc_attr( $atts['alt'] ) . '"';

$effect = 'disabled';

if( $is_hover_effect ) {
	$effect = esc_attr( $atts['hover_style'] );
}

if( isset( $atts['style'] ) ) {
	$wrapper_classes[] = 'style-' . esc_attr( $atts['style'] );
	$wrapper_classes[] = $effect == 'disabled' ? 'effect-disabled' : 'hover-effect effect-' . esc_attr( $effect );

	if( $atts['style'] == 'boxed_rounded' ) {
		$img_classes[] = 'box-rounded';
		$wrapper_classes[] = 'box-element box-rounded';
	} elseif( $atts['style'] == 'boxed' || $atts['style'] == 'polaroid' ) {
		$wrapper_classes[] = 'box-element box-square';
	}

}

$image_align = $atts['image_align'];

if( $image_align <> '' ) {
	$wrapper_classes[] = $image_align;
}

/** animations **/
if( filter_var( $atts['animation'], FILTER_VALIDATE_BOOLEAN ) ) {
	$wrapper_classes[] = 'wow';
	$wrapper_classes[] = $atts['animation_effect'];
	$wrapper_attributes[] = 'data-wow-delay="' . esc_attr( $atts['animation_delay'] ) . '"';
}

$img_url = wp_get_attachment_url( $atts['image'] );

/** href **/
$href_url = $img_url;

if( $is_link || $is_lightbox ) {
	$href_url = $is_link && $atts['link_url'] <> '' ? $atts['link_url'] : $img_url;
	$wrapper_attributes[] = 'data-src="' . esc_attr( $href_url ) . '"';
}

/** start shortcode output **/
echo $image_align == 'aligncenter' ? '<div class="aligncenter img-aligncenter-wrapper">' : '';
echo '<figure class="img-shortcode-wrapper ' . implode(' ', $wrapper_classes ) . '" ' . implode(' ', $wrapper_attributes ) . '>';
echo '<span class="img-wrapper">';

if( $is_link || $is_lightbox ) {

	$href_url = $is_link && $atts['link_url'] <> '' ? $atts['link_url'] : $img_url;
	echo '<a target="' . esc_attr( $atts['link_target'] ) . '" href="' . esc_attr( $href_url ) . '" class="image-href">';
}

echo wplab_albedo_media::image( $img_url, $width, $height, true, true, $img_url, $is_lazy, $img_classes, $img_attributes );

if( $is_link || $is_lightbox ) {
	echo '</a>';
}

echo '</span>';

if( $atts['alt'] <> '' ) {
	echo '<figcaption>' . wp_kses_post( $atts['alt'] ) . '</figcaption>';
}

echo '</figure>';
echo $image_align == 'aligncenter' ? '</div>' : '';
