<?php

  $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

  $classes = $attributes = $form_data = array();

  // Form attributes
  $attributes[] = 'id="albedo-form-' . esc_attr( $atts['el_id'] ) . '"';

  if( $atts['redirect_on_success'] <> '' ) {
    $attributes[] = 'data-redirect-url="' . esc_attr( $atts['redirect_on_success'] ) . '"';
  }

  $attributes[] = 'data-msg-success="' . esc_attr( $atts['success_message'] ) . '"';
  $attributes[] = 'data-lang="' . esc_attr( $atts['lang'] ) . '"';

  $attributes[] = 'data-nonce="' . wp_create_nonce( 'albedo-contact-form') . '"';

  $form_data['email_to'] = $atts['email_to'];
  $form_data['subject_message'] = $atts['subject_message'];
  $form_data['form_id'] = $atts['el_id'];

  $attributes[] = 'data-form-data="' . base64_encode( serialize( $form_data ) ) . '"';

  // Form CSS classes
  $classes[] = $atts['style'] <> '' ? 'form-style-' . $atts['style'] : 'form-style-default';
  $classes[] = $atts['inputs_style'] <> '' ? 'inputs-style-' . $atts['inputs_style'] : 'inputs-style-rounded';

  if( filter_var( $atts['style_boxed'], FILTER_VALIDATE_BOOLEAN ) ) {
    $classes[] = 'box-element box-style-' . $atts['box_style'];
  }

  global $wplab_albedo_shortcode_contact_form, $wplab_albedo_shortcode_contact_form_captcha;
  $wplab_albedo_shortcode_contact_form = $atts;
  $wplab_albedo_shortcode_contact_form_captcha = false;

?>
<div class="albedo-vc-contact-form form-wrapper contact-form <?php echo implode( ' ', $classes ); ?>">
  <form action="javascript:;" method="POST" class="fw_form_fw_form" <?php echo implode( ' ', $attributes ); ?>>
    <?php echo wpb_js_remove_wpautop( $content ); ?>


    <?php
      wp_enqueue_script( 'wplab-albedo-contact-form-validate' );
      wp_enqueue_script( 'wplab-albedo-contact-form' );
    ?>

  </form>
</div>
<?php

if( ! $wplab_albedo_shortcode_contact_form_captcha ) {
  unset( $_SESSION['albedo_contact_form' . $atts['el_id'] ] );
}

unset( $wplab_albedo_shortcode_contact_form );
unset( $wplab_albedo_shortcode_contact_form_captcha );
