<div <?php echo implode(' ', $attributes); ?> class="shortcode-numeric-benefits style-<?php echo esc_attr( $atts['style'] ); ?>" id="shortcode-<?php echo esc_attr( $atts['el_id'] ); ?>">
  <?php
    $animated = filter_var( $atts['animate_on_display'], FILTER_VALIDATE_BOOLEAN );
    $animation = $animated ? $atts['animate_on_display_effect'] : '';
  ?>

  <div class="row">

    <?php
    	$bg_image = $atts['style'] == 'photo' && $atts['background_image'] ? wp_get_attachment_url( $atts['background_image'] ) : '';
    ?>
    <div class="item col-md-12 <?php if( $animated ): ?>wow <?php echo esc_attr( $animation ); endif; ?>" style="<?php if( $bg_image <> '' ): ?>background-image: url(<?php echo esc_attr( $bg_image ); ?><?php endif; ?>" <?php if( $animated ): ?>data-wow-delay="<?php echo esc_attr( $atts['animate_on_display_delay'] ); ?>s"<?php endif; ?>>
    	<div class="item-inside">

    		<div class="number"><?php echo $atts['number']; ?></div>

    		<div class="benefit-text">

    			<?php if( $atts['link'] <> '' ): ?>
    			<a <?php if( filter_var( $atts['link_target'], FILTER_VALIDATE_BOOLEAN ) ): ?>target="_blank"<?php endif; ?> href="<?php echo esc_attr( $atts['link'] ); ?>">
    			<?php endif; ?>

    			<?php if( $atts['title'] <> '' ): ?>
    			<h4><?php echo wp_kses_post( $atts['title'] ); ?></h4>
    			<?php endif; ?>

    			<?php if( $atts['link'] <> '' ): ?>
    			</a>
    			<?php endif; ?>

    			<?php if( $atts['text'] <> '' ): ?>
    			<div class="desc"><?php echo wp_kses_post( $atts['text'] ); ?></div>
    			<?php endif; ?>

    			<?php if( $atts['link'] <> '' && filter_var( $atts['display_button'], FILTER_VALIDATE_BOOLEAN ) ): ?>
    			<a <?php if( filter_var( $atts['link_target'], FILTER_VALIDATE_BOOLEAN ) ): ?>target="_blank"<?php endif; ?> href="<?php echo esc_attr( $atts['link'] ); ?>" class="button style-<?php echo esc_attr( $atts['button_style'] ); ?> size-small"><?php echo wp_kses_post( $atts['button_title'] ); ?></a>
    			<?php endif; ?>

    		</div>

    	</div>
    </div>
  </div>
</div>
