<?php

vc_map( array(
  'name' => esc_html__( 'Vertical Timeline', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_timeline_v',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/vertical-timeline.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/timeline-v/js/vc.js',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add Vertical Timeline', 'wplab-albedo-core-plugin' ),
	'params' => array(

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query type', 'wplab-albedo-core-plugin'),
      'param_name' => 'query_type',
      'admin_label' => true,
      'value' => array(
        esc_html__('All Events', 'wplab-albedo-core-plugin') => 'all',
        esc_html__('Events only from selected categories', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Events except categories', 'wplab-albedo-core-plugin') => 'except',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Slides count', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'value' => '3',
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'param_name' => 'cats',
      'admin_label' => true,
      'value' => '',
      'dependency' => array(
        'element' => 'query_type',
        'value' => array( 'only', 'except' ),
      ),
      'description' => esc_html__( 'Type here categories slugs, e.g. my-category', 'wplab-albedo-core-plugin' ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu_order',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Date format for events', 'wplab-albedo-core-plugin' ),
      'param_name' => 'date_format',
      'value' => 'F Y',
      'save_always' => true,
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Date format for mobile devices', 'wplab-albedo-core-plugin' ),
      'param_name' => 'date_format_mobile',
      'value' => 'Y',
      'save_always' => true,
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Stick timeline', 'wplab-albedo-core-plugin' ),
      'param_name' => 'is_sticky',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Sticky top offset', 'wplab-albedo-core-plugin' ),
      'param_name' => 'scroll_offset_top',
      'value' => '40',
      'save_always' => true,
      'dependency' => array(
  			'element' => 'is_sticky',
  			'not_empty' => true,
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),

  )
));
