<?php

/*
  Add extra options to default "Text" shortcode
*/

vc_map_update( 'vc_column_text', array(
  'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
) );

vc_add_params( 'vc_column_text', array(
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Dropcap', 'wplab-albedo-core-plugin' ),
    'param_name' => 'dropcap',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Dropcap style', 'wplab-albedo-core-plugin'),
    'param_name' => 'dropcap_style',
    'save_always' => true,
    'dependency' => array(
      'element' => 'dropcap',
      'not_empty' => true,
    ),
    'value' => array(
      esc_html__('Blue', 'wplab-albedo-core-plugin') => 'blue',
      esc_html__('Grey', 'wplab-albedo-core-plugin') => 'grey',
      esc_html__('Red', 'wplab-albedo-core-plugin') => 'red',
      esc_html__('Orange', 'wplab-albedo-core-plugin') => 'orange',
      esc_html__('Green', 'wplab-albedo-core-plugin') => 'green',
      esc_html__('Turquoise', 'wplab-albedo-core-plugin') => 'turquoise',
      esc_html__('Purple', 'wplab-albedo-core-plugin') => 'purple',
      esc_html__('Dark Purple', 'wplab-albedo-core-plugin') => 'dark-purple',
      esc_html__('Blue + Shadow', 'wplab-albedo-core-plugin') => 'blue with-shadow',
      esc_html__('Grey + Shadow', 'wplab-albedo-core-plugin') => 'grey with-shadow',
      esc_html__('Red + Shadow', 'wplab-albedo-core-plugin') => 'red with-shadow',
      esc_html__('Orange + Shadow', 'wplab-albedo-core-plugin') => 'orange with-shadow',
      esc_html__('Green + Shadow', 'wplab-albedo-core-plugin') => 'green with-shadow',
      esc_html__('Turquoise + Shadow', 'wplab-albedo-core-plugin') => 'turquoise with-shadow',
      esc_html__('Purple + Shadow', 'wplab-albedo-core-plugin') => 'purple with-shadow',
      esc_html__('Dark Purple + Shadow', 'wplab-albedo-core-plugin') => 'dark-purple with-shadow',
    ),
  ),
));
