(function ( $ ) {

	function wplab_albedo_tabs_refresh() {

		var $iframe = $("#vc_inline-frame"),
		contentWindow = $iframe[0].contentWindow;

		if( 'albedo_tabs_init' in contentWindow ) {
			contentWindow.albedo_tabs_init();
			contentWindow.albedo_tabs_resize();
			contentWindow.themeFrontCore.initLazyLoading();
		} else {
			setTimeout( function() {
				contentWindow.albedo_tabs_init();
				contentWindow.albedo_tabs_resize();
				contentWindow.themeFrontCore.initLazyLoading();
			}, 500 );
		}

	}

	window.InlineShortcodeView_albedo_tabs = window.InlineShortcodeViewContainer.extend({
		render: function () {

			window.InlineShortcodeViewContainer.__super__.render.call(this);
			wplab_albedo_tabs_refresh();

		  return this;
		}
	});

	window.InlineShortcodeView_albedo_tabs_single = window.InlineShortcodeView.extend( {
		render: function () {

			window.InlineShortcodeView_albedo_accordion_section.__super__.render.call( this );
			wplab_albedo_tabs_refresh();

			return this;
		},
		destroy: function(e) {
			if (_.isObject(e) && e.preventDefault() && e.stopPropagation(), !0 !== confirm(window.i18nLocale.press_ok_to_delete_section)) return !1;
			vc.showMessage(window.sprintf(window.i18nLocale.inline_element_deleted, this.model.setting("name"))), this.model.destroy()

			wplab_albedo_tabs_refresh();

		},
		updated: function() {
			_.each(vc.shortcodes.where({
					parent_id: this.model.get("id")
			}), function(model) {
					model.view.parent_view = this, model.view.parentChanged()
			}, this), _.defer(_.bind(function() {
					vc.events.trigger("shortcodeView:updated", this.model), vc.events.trigger("shortcodeView:updated:" + this.model.get("shortcode"), this.model), vc.events.trigger("shortcodeView:updated:" + this.model.get("id"), this.model)
			}, this))

			$(document).ajaxStop(function () {
				wplab_albedo_tabs_refresh();
			});

		},
		clone: function(e) {
			var new_model, builder = new vc.ShortcodesBuilder;
			if (_.isObject(e) && e.preventDefault() && e.stopPropagation(), this.builder && !this.builder.is_build_complete) return !1;
			this.builder = builder, new_model = vc.CloneModel(builder, this.model, this.model.get("parent_id")), builder.setResultMessage(window.sprintf(window.i18nLocale.inline_element_cloned, new_model.setting("name"), new_model.get("id"))), builder.render()

			wplab_albedo_tabs_refresh();
		}
	} );

})( window.jQuery );
