<?php

  /**
    * Portfolio Masonry Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Portfolio_Masonry extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $container_atts = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** load stylesheet **/
    		if( filter_var( $atts['filters'], FILTER_VALIDATE_BOOLEAN ) ) {
          $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/filters.less') );
    			wp_enqueue_style( 'wplab-albedo-filters-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );
    		}

    		/** include Masonry Grid **/
    		wp_enqueue_style( 'masonry', get_template_directory_uri() . '/css/libs/masonry.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
    		wp_enqueue_style( 'masonry-effects', get_template_directory_uri() . '/css/libs/masonry_effects.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );

        wp_dequeue_script( 'isotope');
        wp_register_script( 'albedo-isotope', wplab_albedo_utils::locate_uri( '/js/libs/isotope.pkgd.min.js'), array( 'jquery' ), _WPLAB_ALBEDO_CACHE_TIME_, true );
    		wp_enqueue_script( 'albedo-isotope' );

    		wp_enqueue_script( 'anim-on-scroll' );

        wp_enqueue_style( 'wplab-albedo-portfolio-masonry', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/portfolio_masonry.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/portfolio_masonry_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-portfolio-masonry-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'wplab-albedo-portfolio-masonry', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/portfolio-masonry/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );

        /**
    		 * Custom style settings
    		 **/

         $custom_css = '';

    		if( isset( $atts['custom_radius'] ) && $atts['custom_radius'] <> '' ) {
    			$inline_css = ' #' . $shortcode_id . ' img, #' . $shortcode_id . ' .overlay, #' . $shortcode_id . ' .item, #' . $shortcode_id . ' .grid-item { border-radius: ' . $atts['custom_radius'] . 'px; }';
    			$custom_css .= $inline_css;
    		}

    		if( isset( $atts['filters_link_color'] ) && $atts['filters_link_color'] <> '' ) {
    			$inline_css = '#' . $shortcode_id . ' .posts-filters a { color: ' . $atts['filters_link_color'] . '; }';
    			$custom_css .= $inline_css;
    		}

    		if( isset( $atts['filters_link_active_color'] ) && $atts['filters_link_active_color'] <> '' ) {
    			$inline_css = '#' . $shortcode_id . ' .posts-filters a.active, #' . $shortcode_id . ' .posts-filters a:hover { color: ' . $atts['filters_link_active_color'] . '; }';
    			$custom_css .= $inline_css;
    		}

    		if( isset( $atts['filters_separator_color'] ) && $atts['filters_separator_color'] <> '' ) {
    			$inline_css = '#' . $shortcode_id . ' .posts-filters { color: ' . $atts['filters_separator_color'] . '; }';
    			$custom_css .= $inline_css;
    		}

    		if( isset( $atts['bg_layer1_color'] ) && $atts['bg_layer1_color'] <> '' ) {
    			$inline_css = '#' . $shortcode_id . ' .bg-layer-1 { background-color: ' . $atts['bg_layer1_color'] . '; }';
    			$custom_css .= $inline_css;
    		}

    		if( isset( $atts['bg_layer2_color'] ) && $atts['bg_layer2_color'] <> '' ) {
    			$inline_css = '#' . $shortcode_id . ' .bg-layer-2 { background-color: ' . $atts['bg_layer2_color'] . '; }';
    			$custom_css .= $inline_css;
    		}

        if( $custom_css <> '' ) {
          $container_atts[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_portfolio_masonry.php';
        return ob_get_clean();

      }

    }
  }
