<?php

vc_map( array(
  'name' => esc_html__( 'Styled list', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_list',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/styled-list.png',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add a styled list', 'wplab-albedo-core-plugin' ),
	'params' => array(

    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'List content', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Type here some list content. Begin each list element with *', 'wplab-albedo-core-plugin' ),
      'param_name' => 'text',
      'admin_label' => true,
      'save_always' => true,
      'value' => '* Consectetuer adipiscing elit, sed diam nonummy nibh;
* Investigationes lectores;
* Eodem modo typi, qui nunc nobis videntur parum clari, fiant;
* Quis nostrud exerci ullamcorper.',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('List type', 'wplab-albedo-core-plugin'),
      'param_name' => 'type',
      'save_always' => true,
      'value' => array(
        esc_html__('Unordered list (standard)', 'wplab-albedo-core-plugin') => 'ul',
        esc_html__('Ordered list (standard)', 'wplab-albedo-core-plugin') => 'ol',
        esc_html__('Unordered list (custom bullets)', 'wplab-albedo-core-plugin') => 'ul custom-bullets',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('List style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'admin_label' => true,
      'save_always' => true,
      'value' => array(
        esc_html__('Default style', 'wplab-albedo-core-plugin') => 'default',
        esc_html__('Darken text', 'wplab-albedo-core-plugin') => 'darken',
        esc_html__('Lighten text', 'wplab-albedo-core-plugin') => 'lighten',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('List margins', 'wplab-albedo-core-plugin'),
      'param_name' => 'margins',
      'save_always' => true,
      'value' => array(
        esc_html__('Big', 'wplab-albedo-core-plugin') => 'big',
        esc_html__('Medium', 'wplab-albedo-core-plugin') => 'medium',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),


  )
));
