<?php

/**
 * Modify default Column Shortcode
**/

// Remove default options

vc_remove_param( 'vc_column', 'video_bg' );
vc_remove_param( 'vc_column', 'video_bg_parallax' );
vc_remove_param( 'vc_column', 'video_bg_url' );
vc_remove_param( 'vc_column', 'parallax_speed_video' );
vc_remove_param( 'vc_column', 'parallax' );
vc_remove_param( 'vc_column', 'parallax_image' );
vc_remove_param( 'vc_column', 'parallax_speed_bg' );
vc_remove_param( 'vc_column', 'css' );

vc_map_update( 'vc_column', array(
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/column/js/vc.js',
));

vc_add_params( 'vc_column', array(

  /*
    General Tab
  */
  array(
    'type' => 'el_id',
    'heading' => esc_html__( 'Anchor (row ID)', 'wplab-albedo-core-plugin' ),
    'param_name' => 'el_id',
    'settings' => array(
      'auto_generate' => true,
    ),
    'description' => esc_html__( 'Unique identifier of this column', 'wplab-albedo-core-plugin' ),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Column style', 'wplab-albedo-core-plugin'),
    'param_name' => 'section_style',
    'value' => array(
      esc_html__('Default', 'wplab-albedo-core-plugin') => '',
      esc_html__('Boxed style', 'wplab-albedo-core-plugin') => 'boxed',
      esc_html__('Boxed style, rounded corners', 'wplab-albedo-core-plugin') => 'boxed_rounded',
      esc_html__('Layers style (layers on top)', 'wplab-albedo-core-plugin') => 'bg-layers bg-layers-pos-top',
      esc_html__('Layers style (layers on bottom)', 'wplab-albedo-core-plugin') => 'bg-layers bg-layers-pos-bottom',
    ),
  ),

  /*
    Background tab
  */
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Background type', 'wplab-albedo-core-plugin'),
    'param_name' => 'bg_css_type',
    'value' => array(
      esc_html__('Background color', 'wplab-albedo-core-plugin') => 'color',
      esc_html__('Gradient background', 'wplab-albedo-core-plugin') => 'gradient',
      esc_html__('Custom gradient background', 'wplab-albedo-core-plugin') => 'custom_gradient',
    ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Background Color', 'wplab-albedo-core-plugin' ),
		'param_name' => 'background_color',
		'description' => esc_html__( 'Select the custom background color', 'js_composer' ),
		'value' => '',
		'dependency' => array(
			'element' => 'bg_css_type',
			'value' => array( 'color' ),
		),
		'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
	),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Gradient background from', 'wplab-albedo-core-plugin' ),
		'param_name' => 'background_gradient_primary',
		'value' => '#ffffff',
		'dependency' => array(
			'element' => 'bg_css_type',
			'value' => array( 'gradient', 'custom_gradient' ),
		),
		'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
	),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Gradient background to', 'wplab-albedo-core-plugin' ),
		'param_name' => 'background_gradient_secondary',
		'value' => '#eeeeee',
		'dependency' => array(
			'element' => 'bg_css_type',
			'value' => array( 'gradient', 'custom_gradient' ),
		),
		'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
	),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Gradient direction', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_gradient_direction',
    'value' => array(
      esc_html__('Linear, From Top to Bottom', 'wplab-albedo-core-plugin') => 'top_bottom',
      esc_html__('Linear, From Left to Right', 'wplab-albedo-core-plugin') => 'left_right',
      esc_html__('Linear, From Left Top to Right Bottom', 'wplab-albedo-core-plugin') => 'top_left_bottom_right',
      esc_html__('Linear, From Left Bottom to Right Top', 'wplab-albedo-core-plugin') => 'bottom_left_top_right',
      esc_html__('Radial', 'wplab-albedo-core-plugin') => 'radial',
    ),
    'dependency' => array(
			'element' => 'bg_css_type',
			'value' => array( 'gradient' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Gradient direction', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_custom_gradient_style',
    'value' => array(
      esc_html__('Linear', 'wplab-albedo-core-plugin') => 'linear',
      esc_html__('Radial', 'wplab-albedo-core-plugin') => 'radial',
    ),
    'dependency' => array(
			'element' => 'bg_css_type',
			'value' => array( 'custom_gradient' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Gradient direction', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_custom_gradient_linear_pos',
    'value' => array(
      esc_html__('To bottom right', 'wplab-albedo-core-plugin') => 'top left',
      esc_html__('To bottom', 'wplab-albedo-core-plugin') => 'top',
      esc_html__('To bottom left', 'wplab-albedo-core-plugin') => 'top right',
      esc_html__('To right', 'wplab-albedo-core-plugin') => 'left',
      esc_html__('To left', 'wplab-albedo-core-plugin') => 'right',
      esc_html__('To top right', 'wplab-albedo-core-plugin') => 'bottom left',
      esc_html__('To top', 'wplab-albedo-core-plugin') => 'bottom',
      esc_html__('To top left', 'wplab-albedo-core-plugin') => 'bottom right',
    ),
    'dependency' => array(
			'element' => 'background_custom_gradient_style',
			'value' => array( 'linear' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Gradient position', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_custom_gradient_radial_pos',
    'value' => array(
      esc_html__('Top Left', 'wplab-albedo-core-plugin') => 'left top',
      esc_html__('Top Center', 'wplab-albedo-core-plugin') => 'center top',
      esc_html__('Top Right', 'wplab-albedo-core-plugin') => 'right top',
      esc_html__('Middle Left', 'wplab-albedo-core-plugin') => 'left center',
      esc_html__('Middle Center', 'wplab-albedo-core-plugin') => 'center',
      esc_html__('Middle Right', 'wplab-albedo-core-plugin') => 'right center',
      esc_html__('Bottom Left', 'wplab-albedo-core-plugin') => 'left bottom',
      esc_html__('Bottom Right', 'wplab-albedo-core-plugin') => 'right bottom',
    ),
    'dependency' => array(
			'element' => 'background_custom_gradient_style',
			'value' => array( 'radial' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Gradient size', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_custom_gradient_radial_size',
    'value' => array(
      esc_html__('Closest Side', 'wplab-albedo-core-plugin') => 'closest-side',
      esc_html__('Closest Corner', 'wplab-albedo-core-plugin') => 'closest-corner',
      esc_html__('Farthest side', 'wplab-albedo-core-plugin') => 'farthest-side',
      esc_html__('Farthest corner', 'wplab-albedo-core-plugin') => 'farthest-corner',
    ),
    'dependency' => array(
			'element' => 'background_custom_gradient_style',
			'value' => array( 'radial' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Gradient start position', 'wplab-albedo-core-plugin' ),
    'param_name' => 'custom_background_start_pos',
    'value' => '0',
    'dependency' => array(
			'element' => 'background_custom_gradient_style',
			'value' => array( 'linear', 'radial' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Gradient end position', 'wplab-albedo-core-plugin' ),
    'param_name' => 'custom_background_end_pos',
    'value' => '100',
    'dependency' => array(
			'element' => 'background_custom_gradient_style',
			'value' => array( 'linear', 'radial' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'attach_image',
    'heading' => esc_html__('Background Image', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_image',
    'dependency' => array(
			'element' => 'bg_css_type',
			'value' => array( 'color' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Background image position', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_position',
    'value' => array(
      esc_html__('Left Top', 'wplab-albedo-core-plugin') => 'left top',
      esc_html__('Center Top', 'wplab-albedo-core-plugin') => 'center top',
      esc_html__('Right Top', 'wplab-albedo-core-plugin') => 'right top',
      esc_html__('Left Bottom', 'wplab-albedo-core-plugin') => 'left bottom',
      esc_html__('Center Bottom', 'wplab-albedo-core-plugin') => 'center bottom',
      esc_html__('Right Bottom', 'wplab-albedo-core-plugin') => 'right bottom',
      esc_html__('Left Center', 'wplab-albedo-core-plugin') => 'left center',
      esc_html__('Center Center', 'wplab-albedo-core-plugin') => 'center center',
      esc_html__('Right Center', 'wplab-albedo-core-plugin') => 'right center',
    ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Custom background image position', 'wplab-albedo-core-plugin' ),
    'param_name' => 'custom_background_position',
    'value' => '',
    'description' => esc_html__( 'here you can put own CSS background image position, e.g.: -5% bottom', 'wplab-albedo-core-plugin' ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Background image repeat', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_repeat',
    'value' => array(
      esc_html__('No repeat', 'wplab-albedo-core-plugin') => 'no-repeat',
      esc_html__('Repeat horizontally', 'wplab-albedo-core-plugin') => 'repeat-x',
      esc_html__('Repeat vertically', 'wplab-albedo-core-plugin') => 'repeat-y',
      esc_html__('Repeat horizontally and vertically', 'wplab-albedo-core-plugin') => 'repeat',
    ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Lazy Load Background Image', 'wplab-albedo-core-plugin' ),
    'param_name' => 'background_lazy',
    'description' => esc_html__( 'If enabled, background image will be loaded through JavaScript after text content', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Cover Background Image', 'wplab-albedo-core-plugin' ),
    'param_name' => 'background_cover',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Fixed Background Image', 'wplab-albedo-core-plugin' ),
    'param_name' => 'background_fixed',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),


  /*
    Margins tab
  */
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Column Margins', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'margins',
     'group' => esc_html__('Margins', 'wplab-albedo-core-plugin'),
  ),
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Column Margins (for medium screens)', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'margins_medium',
     'group' => esc_html__('Margins', 'wplab-albedo-core-plugin'),
  ),
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Column Margins (for small screens)', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'margins_mobile',
     'group' => esc_html__('Margins', 'wplab-albedo-core-plugin'),
  ),

  /*
    Paddings tab
  */
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Column Paddings', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'paddings',
     'group' => esc_html__('Paddings', 'wplab-albedo-core-plugin'),
  ),
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Column Paddings (for medium screens)', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'paddings_medium',
     'group' => esc_html__('Paddings', 'wplab-albedo-core-plugin'),
  ),
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Column Paddings (for small screens)', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'paddings_mobile',
     'group' => esc_html__('Paddings', 'wplab-albedo-core-plugin'),
  ),

  /*
    Responsiveness tab
  */
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Hide background image at large screens', 'wplab-albedo-core-plugin' ),
    'param_name' => 'hide_bg_large_screens',
    'description' => esc_html__( 'Background-color will be still visible', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Responsive Options', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Hide background image at medium screens', 'wplab-albedo-core-plugin' ),
    'param_name' => 'hide_bg_medium_screens',
    'description' => esc_html__( 'Background-color will be still visible', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Responsive Options', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Hide background image at small screens', 'wplab-albedo-core-plugin' ),
    'param_name' => 'hide_bg_small_screens',
    'description' => esc_html__( 'Background-color will be still visible', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Responsive Options', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Hide background image at extra small screens', 'wplab-albedo-core-plugin' ),
    'param_name' => 'hide_bg_estra_small_screens',
    'description' => esc_html__( 'Background-color will be still visible', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Responsive Options', 'wplab-albedo-core-plugin'),
  ),
));
