<?php

  /**
    * Blog Carousel 2 Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Blog_Carousel2 extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $classes = $wrapper_classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** include swiper carousel2 library styles **/
    		wp_enqueue_style( 'swiper', get_template_directory_uri() . '/css/libs/swiper.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
    		wp_enqueue_script( 'swiper');

    		wp_enqueue_style( 'wplab-albedo-blog-carousel2', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/blog_carousel2.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/blog_carousel2_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-blog-carousel2-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		wp_enqueue_script( 'wplab-albedo-blog-carousel2-carousel', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/blog-carousel2/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );

    		// custom Css
    		if( $atts['custom_radius'] <> '' ) {
    			$radius = absint( $atts['custom_radius'] );
    			$custom_css = ' #' . $shortcode_id . ' .thumb img, #' . $shortcode_id . ' .overlay, #' . $shortcode_id . ' .thumb { border-radius: ' . $radius . 'px; }';
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
    		}

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_blog_carousel2.php';
        return ob_get_clean();

      }

    }
  }
