<?php

  /**
    * Blog 2 cols Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Blog_2cols extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $wrap_attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        wp_enqueue_script( 'swiper');
    		wp_enqueue_style( 'swiper', get_template_directory_uri() . '/css/libs/swiper.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
        wp_enqueue_style( 'wplab-albedo-blog-2cols', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/blog_2cols.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/blog_2cols_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-blog-2cols-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'fitvids' );
    		wp_enqueue_script( 'wplab-albedo-blog-2cols', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/blog-2cols/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );

    		// custom Css
        $custom_css = '';
    		if( $atts['custom_radius'] <> '' ) {
    			$radius = absint( $atts['custom_radius'] );
    			$custom_css .= '
    				#' . $shortcode_id . ' .post-media img,
    				#' . $shortcode_id . ' .post-media iframe,
    				#' . $shortcode_id . ' .post-media .overlay {
    							-webkit-border-top-left-radius: ' . $radius . 'px;
    							-webkit-border-top-right-radius: ' . $radius . 'px;
    							-moz-border-radius-topleft: ' . $radius . 'px;
    							-moz-border-radius-topright: ' . $radius . 'px;
    			        border-top-left-radius: ' . $radius . 'px;
    			        border-top-right-radius: ' . $radius . 'px;
    				}';
    		}
        if( $custom_css <> '' ) {
          $wrap_attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_blog_2cols.php';
        return ob_get_clean();

      }

    }
  }
