<?php

  /**
    * Benefits / Services Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Benefits extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        fw()->backend->option_type('icon-v2')->packs_loader->enqueue_frontend_css();

        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    	$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** load stylesheet **/
    	wp_enqueue_style( 'wplab-albedo-benefits', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/benefits.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        global $wplab_albedo_core_plugin;
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/benefits_variable.less') );
        wp_enqueue_style( 'wplab-albedo-benefits-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

		/**
		 * Shortcode scripts
		 **/
		wp_enqueue_script( 'wplab-albedo-benefits', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/benefits/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );

		/**
		 * Custom colors
		 **/

        $custom_css = '';

		if( $atts['icon_color'] <> '' ) {

			$inline_css = ' #' . $shortcode_id . ' .icon { color: ' . $atts['icon_color'] . '; }';
			$inline_css .= ' #' . $shortcode_id . ' svg path, #' . $shortcode_id . ' svg rect, #' . $shortcode_id . ' svg polygon, #' . $shortcode_id . ' svg circle { fill: ' . $atts['icon_color'] . '; }';
			$custom_css .= $inline_css;

		}

		if( $atts['icon_hover_color'] <> '' ) {

			$inline_css = ' #' . $shortcode_id . ' .item:hover .icon { color: ' . $atts['icon_hover_color'] . '; }';
			$inline_css .= ' #' . $shortcode_id . ' .item:hover svg path, #' . $shortcode_id . ' .item:hover svg rect, #' . $shortcode_id . ' .item:hover svg polygon, #' . $shortcode_id . ' .item:hover svg circle { fill: ' . $atts['icon_hover_color'] . '; }';
			$custom_css .= $inline_css;

		}

		if( $atts['header_color'] <> '' ) {
			$inline_css = ' #' . $shortcode_id . ' h4 { color: ' . $atts['header_color'] . '; }';
			$custom_css .= $inline_css;
		}

		if( $atts['header_hover_color'] <> '' ) {
			$inline_css = ' #' . $shortcode_id . ' .item:hover h4 { color: ' . $atts['header_hover_color'] . '; }';
			$custom_css .= $inline_css;
		}

		if( $atts['text_color'] <> '' ) {
			$inline_css = ' #' . $shortcode_id . ' .desc { color: ' . $atts['text_color'] . '; }';
			$custom_css .= $inline_css;
		}

		if( $atts['border_color'] <> '' ) {
			$inline_css = ' #' . $shortcode_id . ' .item:after { background: ' . $atts['border_color'] . '; }';
			$custom_css .= $inline_css;
		}

		if( $atts['margin_bottom'] <> '' ) {
			$inline_css = ' #' . $shortcode_id . ' .item { margin-bottom: ' . absint( $atts['margin_bottom'] ) . 'px; }';
			$custom_css .= $inline_css;
		}

        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_benefits.php';
        return ob_get_clean();

      }

    }
  }
