<?php

  /**
    * Benefits Carousel Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Benefits_Carousel extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        fw()->backend->option_type('icon-v2')->packs_loader->enqueue_frontend_css();

        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** load stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-benefits-carousel', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/benefits_carousel.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        global $wplab_albedo_core_plugin;
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/benefits_carousel_variable.less') );
        wp_enqueue_style( 'wplab-albedo-benefits-carousel-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		/** include swiper carousel library styles **/
    		wp_enqueue_style( 'swiper', get_template_directory_uri() . '/css/libs/swiper.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
    		wp_enqueue_script( 'swiper');

    		wp_enqueue_script( 'wplab-albedo-benefits-carousel', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/benefits-carousel/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );


        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_benefits_carousel.php';
        return ob_get_clean();

      }

    }
  }
