﻿var jsonParceiros;
var configurations;
var selectedStations = [];

$(document).ready(function(){	
	var parceiros   = [];
	
	// Parceiros info
	$.ajax({
		url: "ajax/parceiros.json",
		async: false,
		dataType: 'json',
		success: function(jsondata){		
			jsonParceiros  = jsondata;		
		}	
	});
	
	
	// Configurations
	$.ajax({
		url: "ajax/configuration.json",
		async: false,
		dataType: 'json',
		success: function(jsondata){		
			configurations  = jsondata;		
		}
	});
	
	var map;
	var center = (configurations.center_coordinates)? configurations.center_coordinates : [0, 0];
	var iniZoom = (configurations.initial_zoom)? configurations.initial_zoom : 0;
	var southWest = (configurations.south_west_map_bound)? configurations.south_west_map_bound : L.latLng(-90, -180); 
    var northEast = (configurations.north_east_map_bound)? configurations.north_east_map_bound : L.latLng(90, 180);
    var bounds = L.latLngBounds(southWest, northEast);
	if(configurations.information_txt) $("#infoModal .modal-body").html(configurations.information_txt);
	
	var Esri_WorldTopoMap = L.tileLayer('https://api.tiles.mapbox.com/v4/mapbox.streets/{z}/{x}/{y}.png?access_token=pk.eyJ1IjoiemVyZWJlbG8iLCJhIjoiY2phZTF3dDNhMWw3ZDJxbDlneDJrZmtzYyJ9._V08mJyQIlRV1Gy7lrQ8NA', {attribution: ''});

	var overLayers = {};
	
	map = L.map('leafletmap',{center    : center,
							  zoom      : iniZoom,
							  minZoom   : (configurations.min_zoom)? configurations.min_zoom : 2,
							  maxZoom   : (configurations.max_zoom)? configurations.max_zoom : undefined,
							  maxBounds : bounds,
							  maxBoundsViscosity: 1.0,
							  attributionControl: false

							});

	map.addLayer(Esri_WorldTopoMap);

	function getRadius() { return map.getZoom() *1.9; }
	
	var geojsonDefaultStyle  = {
	    radius: getRadius(),
	    fillColor: "#000", // Cor subsituída pela cor do parceiro correspondente
	    weight: 10,
	    opacity: 0,
	    color: "#000",
	    fillOpacity: 0.8
	};	
	var geojsonHighlightStyle = {
	    radius: getRadius(),
	    fillColor: "#555",
	    weight: 10,
	    opacity: 0,
	    color: "#555",    
	    fillOpacity: 0.8
	};
	  	
	for (var key in jsonParceiros) {
		var geojsonFeature = jsonParceiros[key];
		var legendElement = '<li key-id ="' + key + '"class="legend-element"><div class="dot" style="background-color:' + geojsonFeature[0].color + '"></div>' + key + '</li>';
		$("#legendagem ul").append(legendElement);

		var layer = L.geoJson(geojsonFeature, {
			pointToLayer: function (feature, latlng) {
				var geojsonOptions = geojsonDefaultStyle;					
				geojsonOptions.fillColor = geojsonFeature[0].color;
			
    			return L.circleMarker(latlng, geojsonOptions);
			},
			onEachFeature: function (feature, point) {
				parceiros.push(point);
				point.statusNow    = 'default';
				point.statusBefore = 'default';
				point.on('click', function(e) {
					var msgLogo = "";
					var msg = '<div class="box-message"><a href="' + feature.properties.Web + '"><b style="font-size: 1.6em">' +feature.properties.name+'</b></a>';
					msg += '<ul style="list-style-type: none; padding-left: 10px">';

					var fatt = feature.properties;
					for (var att in fatt) {
						switch (att) {
							case "name":
							case "Reasons to join":
								break;
							case "logo":
								msgLogo += '<li><b>Coordinates: </b>'+(feature.geometry.coordinates[0]).toFixed(4)+', '+(feature.geometry.coordinates[1]).toFixed(4)+'</li>';
								msgLogo += '</ul>';
								msgLogo += '</div>';	
								msgLogo += "<a href ='"+ fatt.Web + "'><img style='padding-top: 20px; max-width: 220px !important; max-height: 220px !important;' src='" + fatt.logo + "'></a>";
								break;
							case "Web":
								msg += '<li><b>'+att+': </b><a href="'+ fatt.Web + '" target="_blank">'+fatt[att]+'</a></li>';
								break;
							case "Email":
								msg += '<li><b>'+att+': </b><a href="mailto:'+ fatt.Email + '">'+fatt[att]+'</a></li>';
								break;	
							default:
								msg += '<li><b>'+att+': </b>'+fatt[att]+'</li>';
						}
					}		
					msg += msgLogo;

				  var popup = L.popup({ maxWidth : 500, minWidth : 240 } )
				   .setLatLng(e.latlng) 
				   .setContent(msg)
				   .openOn(map);
				});

				point.on('contextmenu', function(e) {
				    					var msg = '<div class="box-message"><b style="font-size: 1.6em">' +feature.properties.name+'</b>';
					msg += '<ul style="list-style-type: none; padding-left: 10px">';

					var reason = feature.properties["Reasons to join"];	

					//msg += '<li><b>Reasons to join: </b>'+reason+'</li>';
					
					msg += '</ul>';
					msg += '</div>';	

				  var popup = L.popup()
				   .setLatLng(e.latlng) 
				   .setContent(msg)
				   .openOn(map);
				});

				point.on("mouseover", function (e) {
					if(point.statusNow == 'default') {
						var geojsonOptions = geojsonHighlightStyle;					
						geojsonOptions.radius = getRadius();													
						point.setStyle(geojsonHighlightStyle);
						point.statusBefore = point.statusNow;
						point.statusNow = 'onmouse';					
					}
			    });

				point.on("mouseout", function (e) {
					point.statusNow = point.statusBefore;
					point.statusBefore = 'onmouse';
					
					if(point.statusNow == 'default'){		
						var geojsonOptions = this.defaultOptions;					
						geojsonOptions.radius = getRadius();								
						point.setStyle(geojsonOptions); 
						jQuery(this).children(".dot");
					}
				});					
			}				
		});
		overLayers[key] = [layer, true]; //o par indica a camada e que a mesma está adicionada ao mapa
		map.addLayer(layer);
	}
	
	$(".legend-element").click(function () {
		var selectedKeyId = $(this).attr("key-id");
		if(overLayers[selectedKeyId][1]) {
			$(this).addClass("legend-style-disabled");
			map.removeLayer(overLayers[selectedKeyId][0]);
			overLayers[selectedKeyId][1] = false;
			jQuery(this).children(".dot").addClass("dot-disabled");
		} else {
			$(this).removeClass("legend-style-disabled");
			map.addLayer(overLayers[selectedKeyId][0]);
			overLayers[selectedKeyId][1] = true;
			jQuery(this).children(".dot").removeClass("dot-disabled");
		}
			
	});
	
	map.on("zoomend", function(e){
		zoom = getRadius();
		for (var i = 0; i < parceiros.length; i++) {
			var geojsonOptions = parceiros[i].options;
			geojsonOptions.radius = zoom;											
			parceiros[i].setStyle(geojsonOptions); 
		}
	});
	
	$('#leafletmap').focus();
	$('#leafletmap').keydown(function (e) {
	    if (e.keyCode == 16) {
	        $('#leafletmap').css('cursor','crosshair');
	    }
	});
	$('#leafletmap').keyup(function (e) {
	    if (e.keyCode == 16) {
	        $('#leafletmap').css('cursor','');
	    }
	});
});