<?php
/**

 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package vGest
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.0.13/css/all.css" integrity="sha384-DNOHZ68U8hZfKXOrtjWvjxusGo9WQnrNx2sqG0tfsghAvtVlRW3tvkXWZh58N9jp" crossorigin="anonymous">

	<?php wp_head(); ?>
	<style>	
		body { background: #fff; }
		.hentry { margin:0; }
		.entry-footer { display: none; }
		/*--------------------------------------------------------------
		# Header
		--------------------------------------------------------------*/
		.site-title { margin: 1rem; padding: 0; }
		.site-title a { display: block; background: url('<?php echo get_template_directory_uri() ?>/img/logo.jpg') no-repeat center center; background-size: contain; text-indent: -9999rem; width: 280px; height: 100px; } 
		.site-description, .entry-header { display: none; }
		/* Nav */
		.bg-white { background-color: #fff; }
		.navbar-light .navbar-nav .active>.nav-link { color:#1877b9; }
		.navbar-light .navbar-toggler { border: none; font-size: 2rem; }
		/* Medium devices (tablets, 992px and down) */
		@media (max-width: 992px) {
			.navbar-light li { border-bottom: 1px solid #ddd; } 
			.navbar-light li:last-child { border-bottom: none; } 
			.navbar-light .dropdown-menu { border: none; background: #ddd; border-radius: 0; padding: 0; }
			.navbar-light .dropdown-menu li { border-bottom: 1px solid #fff; }
			.navbar-light .dropdown-menu li:last-child { border-bottom: none; } 
			.navbar-light .dropdown-menu li a { padding: .5rem .8rem; color: #666; }
		}
		/* Sub-Titulos */
		.sub-titulos { background: #1877b9 url(<?php echo get_template_directory_uri() ?>/img/logo-fundo.png); background-repeat: no-repeat; background-position: right 30%; padding-top: 2.7rem; padding-bottom: 2.4rem; margin-bottom: 4rem;}
		.sub-titulos h1 { color: #ffffff; text-align: left; }
		#menu-item-dropdown-31 { font-weight: 700; }
		
		/*--------------------------------------------------------------
		# Footer
		--------------------------------------------------------------*/
		.site-footer { padding: 5rem 0 13rem 0; background: url('<?php echo get_template_directory_uri() ?>/img/bg-rodape.jpg') no-repeat center bottom; background-size:100% auto; }
		.site-footer #menu-footer-2 { text-align: right; }
		.site-footer #menu-footer-2 a { color: #fff; font-size: 1.2rem; font-weight: 300; text-decoration: none; }
		.site-footer hr { margin-top: 1.3rem; border-top: 1px solid rgba(255,255,255,1); }
		.site-footer-nav a { text-align: left;  color: rgba(255, 255, 255,.6); font-size: 0.9rem; text-decoration: none; }
		.site-footer-nav a:hover { color: rgba(255, 255, 255,1); text-decoration: none;  }
		
		.logo-rodape { position: absolute; left: 0; bottom: 2%; }
		
		/*--------------------------------------------------------------
		# HomePage
		--------------------------------------------------------------*/
		.class-ifado { padding: 1rem 1rem 1.5rem 1rem; background: #fff; display: block; color: #333; }
		.class-ifado strong { display: block; color: #1877b9; font-size: 2rem; }
		.class-ifado:hover { background: #f5f5f5; text-decoration: none; color: #333; }
		.class-intro { color: #fff; }
		.class-intro p { padding-left: 25%; }
		.class-intro .class-intro-link { padding-left: 0%; }
		.class-intro .class-intro-link a { font-size: 0.8rem; color: rgba(255, 255, 255,.5); }
		.class-intro .class-intro-link a:hover { color: rgba(255, 255, 255,1); }
		@media (max-width: 768px) { .class-intro .vc_column-inner { padding-left: 15px !important; } }
		
		.not-home .wpb_gallery_slides { border-radius: 0; box-shadow: none; border: 0; }
		.not-home .flex-caption p { display: none; }
		.not-home .flex-caption { background: none !important; }
		.not-home .flexslider { background: none !important; margin: 0; }
		.not-home a { color: #fff; font-size: 1.8rem; }
		.not-home a:hover { text-decoration: none; }
		.not-home .flex-control-nav { text-align: left; padding-left: 10px; height: 2px; }
		.not-home .flex-control-paging li a { width: 40px;  height: 2px; background: rgba(255,255,255,.5); }
		.not-home .flex-control-paging li a.flex-active { background: rgba(255,255,255,1); }
		.class-not-home { font-size: 0.8rem; color: rgba(255, 255, 255,.6); margin-left: 1rem; }
		.class-not-home:hover { color: rgba(255, 255, 255,1); text-decoration: none; }		
		.not-home li .link_image img { -webkit-mask-image:-webkit-gradient(linear, left top, left bottom, from(rgba(0,0,0,1)), to(rgba(0,0,0,0))) }	

		.home-topico a { display: block; text-align: center; text-transform: uppercase; color: #757575; font-size: 1rem; font-weight: 400; }
		.home-topico a:hover { color: #000; text-decoration: none; }
		.home-topico a img { width: 100%; margin-bottom: 0.9rem; }
		.home-topico-container { padding: 0 6%; }
		.home-topico-container .home-topico-coluna { width: 10% !important; }
		.home-topico-container img { padding: 1rem 1rem 0 1rem; }
		
		.logos-slider { height:400px; overflow: hidden; }
		.logos-slider .vc_column-inner,
			.logos-slider .wpb_content_element,
			.logos-slider .vc_col-sm-12 { padding: 0 !important; margin: 0 !important; }
		.logos-slider .theme-default .nivoSlider { box-shadow:none; }
		.logos-slider .nivo-controlNav, .logos-slider .nivo-directionNav, .logos-slider .nivo-caption { display: none; }
		.logos-slider-container { background:#1877b9; position: absolute; left: 50%; top: 12%; z-index: 10; margin-left: -30%; width: 60%; color: #fff; padding: 2rem; }
		.logos-slider-container p { margin-bottom: 0; font-size: 0.9em; }
		
		/* Foto do grupo, topo do ecrã */
		.home-photo { height: 200px; }
		@media (min-width: 768px) { .home-photo { height: 300px; }
		@media (min-width: 1200px) { .home-photo { height: 400px; }
		
		/*--------------------------------------------------------------
		# Project
		--------------------------------------------------------------*/
		.tab-quemsomos .vc_tta-tabs-list { border-left: 1px solid #1877b9; }
		.tab-quemsomos .vc_tta-container { margin-bottom: 0 !important; }
		.tab-quemsomos .vc_tta-panel-body { padding-bottom: 5rem !important; }
		.tab-quemsomos .vc_tta-tab.vc_active>a { background-color: #1877b9 !important; color: #fff !important; }
		
		/*--------------------------------------------------------------
		# Blog
		--------------------------------------------------------------*/
		.post { margin-bottom: 1.4rem; }
		.post img { width: 100%; }
		.post .entry-header { display: block; }
		.post .entry-title a { color: #1877b9; }
		.post .entry-title a:hover { text-decoration: none; color: #000; }
		.post .img-fluid { margin-bottom: 1rem; }
		.post .entry-meta { color: #666; margin-bottom: 1rem; font-size: 0.9rem; }
		.post .entry-meta time, .post .entry-meta  a { color: #666; }
		
		/* Paginação */
		.page-numbers:not(:disabled):not(.disabled) { cursor: pointer; }
		.pagination { margin: 4rem auto; border-bottom: 2px solid #e9ecef; }
		.page-numbers:hover { z-index: 2; color: #0056b3; text-decoration: none; background-color: #e9ecef; border-color: #dee2e6; }
		.page-numbers { position: relative; display: block; padding: .5rem .75rem; margin-left: -1px; line-height: 1.25; color: #1877b9; background-color: #fff; border-bottom: 2px solid #fff; }
		.page-item .current { z-index: 1; color: #007bff; border-bottom: 2px solid #007bff; font-weight: 700; }
		.page-item .current:hover { color: #333; border-bottom: 2px solid #007bff; }
		
		/*--------------------------------------------------------------
		# Contactos
		--------------------------------------------------------------*/
		.form-check-input { margin-top: 0; margin-left: -1.25rem; }
		.form-check-input span.wpcf7-list-item { margin: 0; }

		
		   

	</style>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'vgest' ); ?></a>

	<header id="masthead" class="site-header">
		
		<nav class="navbar sticky-top navbar-expand-lg navbar-light bg-white">
			<?php
			the_custom_logo();
			if ( is_front_page() && is_home() ) :
				?>
				<h1 class="site-title"><a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<?php
			else :
				?>
				<p class="site-title"><a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
				<?php
			endif;
			$vgest_description = get_bloginfo( 'description', 'display' );
			if ( $vgest_description || is_customize_preview() ) :
			?>
				<p class="site-description"><?php echo $vgest_description; /* WPCS: xss ok. */ ?></p>
			<?php endif; ?>
		  <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
		    <i class="fas fa-bars"></i>
		  </button>
			<?php
				wp_nav_menu( array(
					'theme_location'  => 'cab-menu',
					'menu_id'        => 'primary-menu',
					'depth'	          => 2, // 1 = no dropdowns, 2 = with dropdowns.
					'container'       => 'div',
					'container_class' => 'collapse navbar-collapse',
					'container_id'    => 'navbarSupportedContent',
					'menu_class'      => 'navbar-nav mr-auto',
					'fallback_cb'     => 'WP_Bootstrap_Navwalker::fallback',
					'walker'          => new WP_Bootstrap_Navwalker(),
				) );
			?>
		</nav>
	</header>

	<div id="content" class="site-content">
