<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_id
 * @var $el_class
 * @var $width
 * @var $offset
 * @var $content - shortcode content
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Column
 */
$el_class = $el_id = $width = $offset = $css_animation = '';
$output = $custom_css = $inline_css = '';
$bg_layers = false;
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

wp_enqueue_script( 'wpb_composer_front_js' );

$width = wpb_translateColumnWidthToSpan( $width );
$width = vc_column_offset_class_merge( $offset, $width );

$css_classes = array(
	$this->getExtraClass( $el_class ) . $this->getCSSAnimation( $css_animation ),
	'wpb_column',
	'vc_column_container',
	$width,
);

$wrapper_attributes = array();

// ID should start from letter
if( strlen( $atts['el_id'] ) > 0 && ctype_digit(substr( $atts['el_id'] , 0, 1)) ) {
  $atts['el_id'] = 'shortcode-' . $atts['el_id'];
}

$shortcode_id = $atts['el_id'];

if( $atts['bg_css_type'] == 'color' ) {
  if( $atts['background_color'] <> '' ) {
    $inline_css .= 'background-color: ' . $atts['background_color'] . '; ';
  }
}

if( $atts['bg_css_type'] == 'gradient' ) {

  $gradient_start_color = esc_html( $atts['background_gradient_primary'] );
  $gradient_end_color = esc_html( $atts['background_gradient_secondary'] );
  $gradient_direction = esc_html( $atts['background_gradient_direction'] );

  if( $gradient_direction == 'top_bottom' ) {

    $inline_css .= 'background: ' . $gradient_start_color . '; background: -moz-linear-gradient(top, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -webkit-gradient(left top, left bottom, color-stop(0%, ' . $gradient_start_color . '), color-stop(100%, ' . $gradient_end_color . ')); background: -webkit-linear-gradient(top, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -o-linear-gradient(top, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -ms-linear-gradient(top, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: linear-gradient(to bottom, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="' . $gradient_start_color . '", endColorstr="' . $gradient_end_color . '", GradientType=0 ); ';

  } else if( $gradient_direction == 'left_right' ) {

    $inline_css .= 'background: ' . $gradient_start_color . '; background: -moz-linear-gradient(left, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -webkit-gradient(left top, right top, color-stop(0%, ' . $gradient_start_color . '), color-stop(100%, ' . $gradient_end_color . ')); background: -webkit-linear-gradient(left, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -o-linear-gradient(left, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -ms-linear-gradient(left, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: linear-gradient(to right, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="' . $gradient_start_color . '", endColorstr="' . $gradient_end_color . '", GradientType=1 ); ';

  } else if( $gradient_direction == 'top_left_bottom_right' ) {

    $inline_css .= 'background: ' . $gradient_start_color . '; background: -moz-linear-gradient(-45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -webkit-gradient(left top, right bottom, color-stop(0%, ' . $gradient_start_color . '), color-stop(100%, ' . $gradient_end_color . ')); background: -webkit-linear-gradient(-45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -o-linear-gradient(-45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -ms-linear-gradient(-45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: linear-gradient(135deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="' . $gradient_start_color . '", endColorstr="' . $gradient_end_color . '", GradientType=1 ); ';

  } else if( $gradient_direction == 'bottom_left_top_right' ) {

    $inline_css .= 'background: ' . $gradient_start_color . '; background: -moz-linear-gradient(45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -webkit-gradient(left bottom, right top, color-stop(0%, ' . $gradient_start_color . '), color-stop(100%, ' . $gradient_end_color . ')); background: -webkit-linear-gradient(45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -o-linear-gradient(45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -ms-linear-gradient(45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: linear-gradient(45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="' . $gradient_start_color . '", endColorstr="' . $gradient_end_color . '", GradientType=1 ); ';

  } else if( $gradient_direction == 'radial' ) {

    $inline_css .= 'background: ' . $gradient_start_color . '; background: -moz-radial-gradient(center, ellipse cover, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, ' . $gradient_start_color . '), color-stop(100%, ' . $gradient_end_color . ')); background: -webkit-radial-gradient(center, ellipse cover, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -o-radial-gradient(center, ellipse cover, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -ms-radial-gradient(center, ellipse cover, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: radial-gradient(ellipse at center, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="' . $gradient_start_color . '", endColorstr="' . $gradient_end_color . '", GradientType=1 ); ';

  }

} elseif( $atts['bg_css_type'] == 'custom_gradient' ) {

 $gradient_style = esc_html( $atts['background_custom_gradient_style'] );

 $gradient_start_color = esc_html( $atts['background_gradient_primary'] );
 $gradient_end_color = esc_html( $atts['background_gradient_secondary'] );
 $gradient_start = absint( $atts['custom_background_start_pos'] );
 $gradient_end = absint( $atts['custom_background_end_pos'] );

 if( $gradient_style == 'radial' ) {

 $gradient_size = esc_html( $atts['background_custom_gradient_radial_size'] );
 $gradient_position = esc_html( $atts['background_custom_gradient_radial_pos'] );

 $inline_css .= '
background-image: -ms-radial-gradient(' . $gradient_position . ', ellipse ' . $gradient_size . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
background-image: -moz-radial-gradient(' . $gradient_position . ', ellipse ' . $gradient_size . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
background-image: -o-radial-gradient(' . $gradient_position . ', ellipse ' . $gradient_size . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
background-image: -webkit-radial-gradient(' . $gradient_position . ', ellipse ' . $gradient_size . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
 ';

 } elseif( $gradient_style == 'linear' ) {

 $gradient_position = esc_html( $atts['background_custom_gradient_linear_pos'] );

   $inline_css .= '
background-image: -ms-linear-gradient(' . $gradient_position . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
background-image: -moz-linear-gradient(' . $gradient_position . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
background-image: -o-linear-gradient(' . $gradient_position . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
background-image: -webkit-linear-gradient(' . $gradient_position . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
   ';

 }

}

if( ! filter_var( $atts['background_lazy'], FILTER_VALIDATE_BOOLEAN ) && $atts['background_image'] <> '' ) {
 $inline_css .= 'background-image: url(' . wp_get_attachment_url( $atts['background_image'] ) . '); ';
} elseif( $atts['background_image'] <> '' ) {
	$css_classes[] = 'b-lazy';
	$wrapper_attributes[] = 'data-lazy-src="' . wp_get_attachment_url( $atts['background_image'] ) . '"';
}

if( $atts['background_repeat'] <> '' ) {
 $inline_css .= 'background-repeat: ' . $atts['background_repeat'] . '; ';
}

if( $atts['background_position'] <> '' ) {
 $inline_css .= 'background-position: ' . $atts['background_position'] . '; ';
}

if( $atts['custom_background_position'] <> '' ) {
 $inline_css .= 'background-position: ' . $atts['custom_background_position'] . '; ';
}

if( filter_var( $atts['background_cover'], FILTER_VALIDATE_BOOLEAN ) ) {
 $inline_css .= 'background-size: cover; ';
}

if( filter_var( $atts['background_fixed'], FILTER_VALIDATE_BOOLEAN ) ) {
 $inline_css .= 'background-attachment: fixed; ';
}

if( $atts['margins'] <> '' ) {
  $sides_data = explode( '|', $atts['margins'] );
  $inline_css .= wplab_albedo_utils::get_styles( array(
    'top_margin' 			=> $sides_data[0],
    'right_margin' 		=> $sides_data[1],
    'bottom_margin' 	=> $sides_data[2],
    'left_margin' 		=> $sides_data[3],
  ), '' );
}

if( $atts['paddings'] <> '' ) {
  $sides_data = explode( '|', $atts['paddings'] );
  $inline_css .= wplab_albedo_utils::get_styles( array(
    'top_padding' 			=> $sides_data[0],
    'right_padding' 		=> $sides_data[1],
    'bottom_padding' 	=> $sides_data[2],
    'left_padding' 		=> $sides_data[3],
  ), '' );
}

if( $inline_css <> '' ) {
  $custom_css .= ' #' . $shortcode_id . ' {' . $inline_css . '}';
}

/**
 * Responsiveness, medium screen
 **/
$inline_css = '';

  if( $atts['margins_medium'] <> '' ) {
    $sides_data = explode( '|', $atts['margins_medium'] );
    $inline_css .= wplab_albedo_utils::get_styles( array(
      'top_margin' 			=> $sides_data[0],
      'right_margin' 		=> $sides_data[1],
      'bottom_margin' 	=> $sides_data[2],
      'left_margin' 		=> $sides_data[3],
    ), '' );
  }

  if( $atts['paddings_medium'] <> '' ) {
    $sides_data = explode( '|', $atts['paddings_medium'] );
    $inline_css .= wplab_albedo_utils::get_styles( array(
      'top_padding' 		=> $sides_data[0],
      'right_padding' 	=> $sides_data[1],
      'bottom_padding' 	=> $sides_data[2],
      'left_padding' 		=> $sides_data[3],
    ), '' );
  }

if( $inline_css <> '' ) {
  $custom_css .= '@media screen and (max-width: 1199px) and (min-width: 767px) { #' . $shortcode_id . ' { ' . $inline_css . '} }';
}

/**
 * Responsiveness, small screen
 **/
$inline_css = '';

  if( $atts['margins_mobile'] <> '' ) {
    $sides_data = explode( '|', $atts['margins_mobile'] );
    $inline_css .= wplab_albedo_utils::get_styles( array(
      'top_margin' 			=> $sides_data[0],
      'right_margin' 		=> $sides_data[1],
      'bottom_margin' 	=> $sides_data[2],
      'left_margin' 		=> $sides_data[3],
    ), '' );
  }

  if( $atts['paddings_mobile'] <> '' ) {
    $sides_data = explode( '|', $atts['paddings_mobile'] );
    $inline_css .= wplab_albedo_utils::get_styles( array(
      'top_padding' 		=> $sides_data[0],
      'right_padding' 	=> $sides_data[1],
      'bottom_padding' 	=> $sides_data[2],
      'left_padding' 		=> $sides_data[3],
    ), '' );
  }

if( $inline_css <> '' ) {
  $custom_css .= '@media screen and (max-width: 991px) { #' . $shortcode_id . ' { ' . $inline_css . '} }';
}

$wrapper_attributes[] = 'data-custom-css=\'' . $custom_css . '\'';

if( $atts['section_style'] <> '' ) {
  if( $atts['section_style'] == 'boxed_rounded' ) {
    $css_classes[] = 'box-element box-rounded';
  } elseif( $atts['section_style'] == 'boxed' ) {
    $css_classes[] = 'box-element box-square';
  } else {
    $css_classes[] = $atts['section_style'];
    $css_classes[] = 'wow';
    $bg_layers = true;
  }
}

if( filter_var( $atts['hide_bg_large_screens'], FILTER_VALIDATE_BOOLEAN ) ) {
  $css_classes[] = 'bgimage-hidden-lg';
}

if( filter_var( $atts['hide_bg_medium_screens'], FILTER_VALIDATE_BOOLEAN ) ) {
  $css_classes[] = 'bgimage-hidden-md';
}

if( filter_var( $atts['hide_bg_small_screens'], FILTER_VALIDATE_BOOLEAN ) ) {
  $css_classes[] = 'bgimage-hidden-sm';
}

if( filter_var( $atts['hide_bg_estra_small_screens'], FILTER_VALIDATE_BOOLEAN ) ) {
  $css_classes[] = 'bgimage-hidden-xs';
}

$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $css_classes ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $shortcode_id ) . '"';
$output .= '<div ' . implode( ' ', $wrapper_attributes ) . '>';
$output .= '<div class="vc_column-inner">';
$output .= '<div class="wpb_wrapper">';

if( $bg_layers ):
  $output .= '<div class="bg-layer-1"></div>';
  $output .= '<div class="bg-layer-2"></div>';
endif;

$output .= wpb_js_remove_wpautop( $content );
$output .= '</div>';
$output .= '</div>';
$output .= '</div>';

echo $output;
