<?php
  global $wplab_albedo_core;
  $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

	$attributes = $classes = array();

	/** unique id **/
	$attributes[] = 'id="shortcode-' . esc_attr( $atts['el_id'] ) . '"';

  $terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

  $items = $wplab_albedo_core->model('post')->get( array(
    'post_type' => 'timeline_events',
    'type' => $atts['query_type'],
    'posts_per_page' => absint( $atts['posts_per_page'] ),
    'order' => $atts['order_by'],
    'sort' => $atts['sort_by'],
    'tax_name' => 'timeline_events_category',
    'term_field' => 'slug',
    'terms' => $terms
  ) );

?>

<div <?php echo implode( ' ', $attributes ); ?> class="cv-timeline <?php echo implode( ' ', $classes ); ?>">
	<div class="items">
    <?php
      $date_format = $atts['date_format'];
      while ( $items->have_posts() ): $items->the_post();
    ?>
    <div class="item">

      <div class="dot"></div>

      <div class="dates">

        <?php
          $start_date = date( $date_format, strtotime( fw_get_db_post_option( get_the_ID(), 'date_start' ) ) );
          $end_date = date( $date_format, strtotime( fw_get_db_post_option( get_the_ID(), 'date_end' ) ) );

          echo $start_date;

          if( $end_date <> '' ) {
            echo ' - ' . $end_date;
          }

          $url = strip_tags( get_the_content() );
        ?>

      </div>

      <div class="text">
        <div class="position"><?php the_title(); ?></div>
        <div class="website"><a target="_blank" href="<?php echo esc_attr( $url ); ?>"><?php echo $url; ?></a></div>
      </div>

    </div>
    <?php endwhile; wp_reset_postdata(); ?>

	</div>
	<span class="filling-line"></span>
</div>
