<?php
	global $wplab_albedo_core;
	$attributes = $classes = array();

	$id = esc_attr( $atts['el_id'] );

	/** unique id **/
	$attributes[] = 'id="shortcode-' . $id . '"';
	$classes[] = 'cols-' . absint( $atts['cols'] );

	$cols = absint( $atts['cols'] );
	$column = 12/$cols;

	$terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

  $items = $wplab_albedo_core->model('post')->get( array(
    'post_type' => 'team',
    'type' => $atts['query_type'],
    'posts_per_page' => absint( $atts['posts_per_page'] ),
    'order' => $atts['order_by'],
    'sort' => $atts['sort_by'],
    'tax_name' => 'team_category',
    'term_field' => 'slug',
    'terms' => $terms
  ) );

?>

<div class="team-members <?php echo implode(' ', $classes); ?>" <?php echo implode( ' ', $attributes ); ?>>

	<?php $counter = 0; while ( $items->have_posts() ): $items->the_post(); ?>

	<?php
	  $animated = filter_var( $atts['animate_on_display'], FILTER_VALIDATE_BOOLEAN );
		$animation = $animated ? $atts['animate_on_display_effect'] : '';
		$animation_step = $animated ? $atts['animate_on_display_step'] : '';

		$animated_on_hover = filter_var( $atts['animate_on_hover'], FILTER_VALIDATE_BOOLEAN );
		$hover_animation = $animated_on_hover ? $atts['animate_on_hover_effect'] : '';

	?>
	<?php if( $counter % $cols == 0 ): ?>
	<div class="row">
	<?php endif; $counter++; ?>

	<?php $is_vacancy = filter_var( fw_get_db_post_option( get_the_ID(), 'is_vacancy' ), FILTER_VALIDATE_BOOLEAN ); ?>

	<div class="item col-md-<?php echo $column; ?> <?php echo $is_vacancy ? 'vacancy' : ''; ?> <?php if( $animated ): ?>wow <?php echo esc_attr( $animation ); endif; ?>" <?php if( $animated ): ?>data-wow-delay="<?php echo esc_attr( $animation_step * $counter / 2 ); ?>s"<?php endif; ?>>

	  <?php
	    $text = get_the_content();
	    $name = get_the_title();
	    $position = fw_get_db_post_option( get_the_ID(), 'position' );
	    $photo = get_the_post_thumbnail_url( get_the_ID(), 'full');
	  ?>

	  <div class="inside">

	    <div class="photo<?php if( $animated_on_hover ): ?> animate-on-hover<?php endif; ?>" data-hover-animation="<?php echo esc_attr($hover_animation); ?>">
	      <?php if( $photo <> '' ): ?>
	        <?php echo wplab_albedo_media::image( $photo, 160, 160, true, true, $photo ); ?>
	      <?php else: ?>
	        <div class="placeholder"></div>
	      <?php endif; ?>
	    </div>

	    <div class="text-content">

	      <?php if( $position <> '' ): ?>
	      <div class="position">
	        <?php echo wp_kses_post( $position ); ?>
	      </div>
	      <?php endif; ?>

	      <?php if( $name <> '' ): ?>
	      <div class="name">
	        <?php echo wp_kses_post( $name ); ?>
	      </div>
	      <?php endif; ?>

	      <?php if( $text <> '' ): ?>
	      <div class="text">
	        <?php echo wp_kses_post( $text ); ?>
	      </div>
	      <?php endif; ?>

	      <div class="social">
					<?php
						$custom_fields = get_post_custom();
						$fields = isset( $custom_fields['fw_options'][0] ) ? unserialize( $custom_fields['fw_options'][0] ) : array();
						wplab_albedo_front::print_fa_icons( $fields );
					?>
	      </div>

	      <?php if( filter_var( fw_get_db_post_option( get_the_ID(), 'display_button' ), FILTER_VALIDATE_BOOLEAN ) ): ?>
	      <div class="btn">
	        <a href="<?php echo esc_attr( fw_get_db_post_option( get_the_ID(), 'button_url' ) ); ?>" class="button size-medium style-<?php echo esc_attr( fw_get_db_post_option( get_the_ID(), 'button_style' ) ); ?>" target="_blank"><?php echo fw_get_db_post_option( get_the_ID(), 'button_text' ); ?></a>
	      </div>
	      <?php endif; ?>

	    </div>

	  </div>

	</div>

	<?php if( $counter % $cols == 0 ): ?>
	</div>
	<?php endif; ?>

	<?php endwhile; wp_reset_postdata(); ?>

	<?php if( $counter % $cols != 0 ): ?>
	</div>
	<?php endif; ?>

</div>
