<?php
	global $wplab_albedo_core;
	$attributes = $classes = array();
	$id = esc_attr( $atts['el_id'] );

	$attributes[] = 'id="shortcode-' . $id . '"';

	$attributes[] = 'data-effect="' . esc_attr( $atts['effect'] ) . '"';
	$attributes[] = 'data-pagination="' . esc_attr( $atts['pagination'] ) . '"';
	$attributes[] = 'data-loop="' . esc_attr( $atts['loop'] ) . '"';

	$attributes[] = 'data-slides-num="' . absint( $atts['items_big'] ) . '"';
	$attributes[] = 'data-slides-medium-num="' . absint( $atts['items_medium'] ) . '"';
	$attributes[] = 'data-slides-small-num="' . absint( $atts['items_small'] ) . '"';

	$attributes[] = 'data-start-slide="' . absint( $atts['slide_start'] ) . '"';

	if( filter_var( $atts['autoplay'], FILTER_VALIDATE_BOOLEAN ) ) {
		$attributes[] = 'data-autoplay="' . esc_attr( $atts['autoplay_speed'] ) . '"';
		$attributes[] = 'data-autoplay-stop-on-last="' . esc_attr( $atts['autoplay_stop_on_last'] ) . '"';
		$attributes[] = 'data-autoplay-disable-on-interaction="' . esc_attr( $atts['autoplay_disable_on_interaction'] ) . '"';
	}

	$terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

  $items = $wplab_albedo_core->model('post')->get( array(
    'post_type' => 'team',
    'type' => $atts['query_type'],
    'posts_per_page' => absint( $atts['posts_per_page'] ),
    'order' => $atts['order_by'],
    'sort' => $atts['sort_by'],
    'tax_name' => 'team_category',
    'term_field' => 'slug',
    'terms' => $terms
  ) );

?>
<div class="team-cards2 <?php echo implode(' ', $classes); ?>" <?php echo implode( ' ', $attributes ); ?>>

	<!-- Slider main container -->
	<div class="swiper-container">

    <!-- Additional required wrapper -->
    <div class="swiper-wrapper">
			<?php while ( $items->have_posts() ): $items->the_post(); ?>
			<div class="swiper-slide">
			  <div class="item-content">

			    <?php
						$text = get_the_content();
						$name = get_the_title();
						$position = fw_get_db_post_option( get_the_ID(), 'position' );
						$photo = get_the_post_thumbnail_url( get_the_ID(), 'full');
			    ?>

			    <div class="photo">
			      <?php if( $photo <> '' ): ?>
			        <?php
			          $img_width = absint( $atts['photo_width'] );
			          $img_height = absint( $atts['photo_height'] );
			          echo wplab_albedo_media::image( $photo, $img_width, $img_height, true, true, $photo );
			        ?>
			      <?php endif; ?>
			    </div>

			    <div class="text-content">

			      <div class="text-inside">
			        <?php if( $name <> '' ): ?>
			        <div class="name">
			          <?php echo wp_kses_post( $name ); ?>
			        </div>
			        <?php endif; ?>

			        <?php if( $position <> '' ): ?>
			        <div class="position">
			          <?php echo wp_kses_post( $position ); ?>
			        </div>
			        <?php endif; ?>

			        <div class="toggle-text">
			          <?php if( $text <> '' ): ?>
			          <div class="text">
			            <?php echo wp_kses_post( $text ); ?>
			          </div>
			          <?php endif; ?>

			          <div class="social">
									<?php
										$custom_fields = get_post_custom();
										$fields = isset( $custom_fields['fw_options'][0] ) ? unserialize( $custom_fields['fw_options'][0] ) : array();
										wplab_albedo_front::print_fa_icons( $fields );
									?>
			          </div>
			        </div>
			      </div>

			    </div>

			  </div>
			</div>
			<?php endwhile; wp_reset_postdata(); ?>
    </div>

		<?php if( filter_var( $atts['pagination'], FILTER_VALIDATE_BOOLEAN ) ): ?>
	  <!-- If we need pagination -->
	  <div class="swiper-pagination"></div>
	  <?php endif; ?>

	</div>

</div>
