<?php

vc_map( array(
  'name' => esc_html__( 'Tabs', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_tabs',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/tabs.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/tabs/js/vc.js',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add tabs', 'wplab-albedo-core-plugin' ),
  'as_parent' => array( 'only' => 'albedo_tabs_single' ),
  'content_element' => true,
  'is_container' => true,
  'show_settings_on_create' => true,
  'js_view' => is_admin() ? 'VcColumnView' : 'ViewAlbedoTabs',
	'params' => array(

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Tabs style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'admin_label' => true,
      'save_always' => true,
      'value' => array(
        esc_html__('Simple', 'wplab-albedo-core-plugin') => 'simple',
        esc_html__('Modern', 'wplab-albedo-core-plugin') => 'modern',
        esc_html__('Modern Alternate', 'wplab-albedo-core-plugin') => 'modern_alt',
      ),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Tabs type', 'wplab-albedo-core-plugin'),
      'param_name' => 'type',
      'save_always' => true,
      'admin_label' => true,
      'value' => array(
        esc_html__('Horizontal', 'wplab-albedo-core-plugin') => 'horizontal',
        esc_html__('Vertical', 'wplab-albedo-core-plugin') => 'vertical',
      ),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display tab title within Content', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'If enabled, tab title will be duplicated in Tab Content area', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_title',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Responsive at', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'For example: 767. If screen size will be less than this number, tabs will be turned into small screen mode', 'wplab-albedo-core-plugin' ),
      'param_name' => 'responsive_break',
      'value' => '',
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'An unique identifier of this element', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'value' => '',
    ),

  )
));

vc_map( array(
  'name' => esc_html__( 'Tab', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_tabs_single',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/tabs.png',
  'content_element' => true,
  'as_child' => array( 'only' => 'albedo_tabs' ),
	'params' => array(

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'title',
      'admin_label' => true,
      'value' => esc_html__( 'Tab title', 'wplab-albedo-core-plugin' ),
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Content', 'wplab-albedo-core-plugin' ),
      'param_name' => 'content',
      'value' => esc_html__( 'Tab content', 'wplab-albedo-core-plugin' ),
    ),
    array(
      'type' => 'iconpicker',
      'heading' => esc_html__('Tab Icon', 'wplab-albedo-core-plugin'),
      'param_name' => 'tab_icon',
      'settings' => array(
        'emptyIcon' => true,
        'type' => 'fontawesome',
      )
    ),
    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Tab Image', 'wplab-albedo-core-plugin'),
      'param_name' => 'tab_image',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Image width', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Value in pixels, for example: 400', 'wplab-albedo-core-plugin' ),
      'param_name' => 'image_width',
      'value' => '',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Image height', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Value in pixels, for example: 400', 'wplab-albedo-core-plugin' ),
      'param_name' => 'image_height',
      'value' => '',
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display a button', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_button',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Button title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'button_title',
      'save_always' => true,
      'value' => esc_html__( 'Read more', 'wplab-albedo-core-plugin' ),
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Button URL', 'wplab-albedo-core-plugin' ),
      'param_name' => 'button_url',
      'value' => '',
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__( 'Button style', 'wplab-albedo-core-plugin' ),
      'param_name' => 'button_style',
      'save_always' => true,
      'value' => $this->cfg['button_styles'],
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
    ),

  )
));
