<?php

  /**
    * Table Shortcode
  **/

  vc_map( array(
    'name' => esc_html__( 'Table / Pricing Table', 'wplab-albedo-core-plugin' ),
  	'base' => 'albedo_table',
    'icon' => $this->plugin_uri . '/assets/shortcode_icons/table.png',
    'front_enqueue_js' => $this->plugin_uri . '/shortcodes/table/js/vc.js',
  	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
  	'description' => esc_html__( 'Add table or pricing table', 'wplab-albedo-core-plugin' ),
  	'params' => array(

      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Table ID', 'wplab-albedo-core-plugin' ),
        'description' => esc_html__( 'Type here an ID of Table to display it. Table ID can be found near the Table Title in the Pricing Tables posts list.', 'wplab-albedo-core-plugin' ),
        'param_name' => 'table_id',
        'admin_label' => true,
        'value' => '',
      ),

    )
  ));

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Table extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        /** load static stylesheet **/
        wp_enqueue_style( 'wplab-albedo-tables', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/table.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        global $wplab_albedo_core_plugin;
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/table_variable.less') );
        wp_enqueue_style( 'wplab-albedo-tables-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_table.php';
        return ob_get_clean();

      }
    }
  }
