(function ( $ ) {

	function albedo_shop_refresh( element ) {

		var $iframe = $("#vc_inline-frame"),
		iframeContents = $iframe.contents(),
		contentWindow = $iframe[0].contentWindow;
    
		contentWindow.themeFrontCore.initLazyLoading();
		contentWindow.themeFrontCore.loadSVG();

		if( 'wplab_albedo_shop_init' in contentWindow ) {
			contentWindow.wplab_albedo_shop_init();
		} else {
			setTimeout( function() {
				contentWindow.wplab_albedo_shop_init();
			}, 500 );
		}

	}

	window.InlineShortcodeView_albedo_shop = window.InlineShortcodeView.extend({
		render: function () {

			window.InlineShortcodeView_albedo_shop.__super__.render.call( this );
			albedo_shop_refresh( this );

		  return this;
		},
		updated: function() {
			_.each(vc.shortcodes.where({
					parent_id: this.model.get("id")
			}), function(model) {
					model.view.parent_view = this, model.view.parentChanged()
			}, this), _.defer(_.bind(function() {
					vc.events.trigger("shortcodeView:updated", this.model), vc.events.trigger("shortcodeView:updated:" + this.model.get("shortcode"), this.model), vc.events.trigger("shortcodeView:updated:" + this.model.get("id"), this.model)
			}, this))

			// wait until element will be fully loaded
			var instance = this;
	    $(document).ajaxStop(function () {
				albedo_shop_refresh( instance );
			});

		}
	});

})( window.jQuery );
