<?php

vc_map( array(
  'name' => esc_html__( 'Progress Bar', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_progress_bar',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/progress-bar.png',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add a progress bar', 'wplab-albedo-core-plugin' ),
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/progress/js/vc.js',
	'params' => array(

    /**
     *  General tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'title',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Value', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Value number can be from 0 to 100', 'wplab-albedo-core-plugin' ),
      'param_name' => 'value',
      'admin_label' => true,
      'save_always' => true,
      'value' => '95',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Bar style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'admin_label' => true,
      'save_always' => true,
      'value' => array(
        esc_html__('Blue', 'wplab-albedo-core-plugin') => 'blue',
        esc_html__('Black', 'wplab-albedo-core-plugin') => 'black',
        esc_html__('Grey', 'wplab-albedo-core-plugin') => 'grey',
        esc_html__('Red', 'wplab-albedo-core-plugin') => 'red',
        esc_html__('Orange', 'wplab-albedo-core-plugin') => 'orange',
        esc_html__('Green', 'wplab-albedo-core-plugin') => 'green',
        esc_html__('Turquoise', 'wplab-albedo-core-plugin') => 'turquoise',
        esc_html__('Yellow', 'wplab-albedo-core-plugin') => 'yellow',
        esc_html__('Purple', 'wplab-albedo-core-plugin') => 'purple',
        esc_html__('Dark Purple', 'wplab-albedo-core-plugin') => 'dark-purple',

        esc_html__('3D Blue', 'wplab-albedo-core-plugin') => 'type-3d blue',
        esc_html__('3D Black', 'wplab-albedo-core-plugin') => 'type-3d black',
        esc_html__('3D Grey', 'wplab-albedo-core-plugin') => 'type-3d grey',
        esc_html__('3D Red', 'wplab-albedo-core-plugin') => 'type-3d red',
        esc_html__('3D Orange', 'wplab-albedo-core-plugin') => 'type-3d orange',
        esc_html__('3D Green', 'wplab-albedo-core-plugin') => 'type-3d green',
        esc_html__('3D Turquoise', 'wplab-albedo-core-plugin') => 'type-3d turquoise',
        esc_html__('3D Yellow', 'wplab-albedo-core-plugin') => 'type-3d yellow',
        esc_html__('3D Purple', 'wplab-albedo-core-plugin') => 'type-3d purple',
        esc_html__('3D Dark Purple', 'wplab-albedo-core-plugin') => 'type-3d dark-purple',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Custom colors tab
    **/
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Bar background color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'bar_bg_color',
  		'value' => '',
  		'group' => esc_html__('Custom colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Bar accent color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'bar_accent_color',
  		'value' => '',
  		'group' => esc_html__('Custom colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Description color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'text_color',
  		'value' => '',
  		'group' => esc_html__('Custom colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Value color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'value_color',
  		'value' => '',
  		'group' => esc_html__('Custom colors', 'wplab-albedo-core-plugin'),
  	),


  )
));
