<?php

vc_map( array(
  'name' => esc_html__( 'Image', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_image',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/image.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/media-image/js/vc.js',
	'category' => esc_html__( 'Media', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add an image', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  Image tab
    **/

    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Upload image', 'wplab-albedo-core-plugin'),
      'description' => esc_html__('Either upload a new, or choose an existing image from your media library.', 'wplab-albedo-core-plugin'),
      'param_name' => 'image',
      'group' => esc_html__('Image', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Alternate Text', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( '(optional, used in image ALT attribute and as figure caption text)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'alt',
      'value' => '',
      'group' => esc_html__('Image', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Width', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set image width (optional)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'width',
      'value' => '',
      'group' => esc_html__('Image', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Height', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set image height (optional)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'height',
      'value' => '',
      'group' => esc_html__('Image', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Image Style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'save_always' => true,
      'value' => array(
        esc_html__('Default / custom effects', 'wplab-albedo-core-plugin') => '',
        esc_html__('Boxed style', 'wplab-albedo-core-plugin') => 'boxed',
        esc_html__('Boxed, rounded corners', 'wplab-albedo-core-plugin') => 'boxed_rounded',
        esc_html__('Polaroid', 'wplab-albedo-core-plugin') => 'polaroid',
      ),
      'group' => esc_html__('Image', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Add hover effect?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'hover_effect',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Image', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Hover Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'hover_style',
      'save_always' => true,
      'value' => array(
        esc_html__('Default', 'wplab-albedo-core-plugin') => 'default',
        esc_html__('Slide (from right to left)', 'wplab-albedo-core-plugin') => 'slide-right-left',
        esc_html__('Zoom Out', 'wplab-albedo-core-plugin') => 'zoom-out',
        esc_html__('Zoom In', 'wplab-albedo-core-plugin') => 'zoom-in',
        esc_html__('Big Zoom', 'wplab-albedo-core-plugin') => 'big-zoom',
        esc_html__('Zoom 3D', 'wplab-albedo-core-plugin') => 'zoom-3d',
        esc_html__('Zoom and Slide', 'wplab-albedo-core-plugin') => 'zoom-slide',
        esc_html__('Shine', 'wplab-albedo-core-plugin') => 'shine',
      ),
      'dependency' => array(
  			'element' => 'hover_effect',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Image', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('Image', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Options tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Lazy Load', 'wplab-albedo-core-plugin' ),
      'param_name' => 'lazy_load',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Options', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Add a link?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'add_link',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Options', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Link URL', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'optional, leave this field empty to use Current Image URL', 'wplab-albedo-core-plugin' ),
      'param_name' => 'link_url',
      'value' => '',
      'dependency' => array(
  			'element' => 'add_link',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Options', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Open image in lightbox?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'lightbox',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Options', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Open link at new tab?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'link_target',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => '_blank' ),
      'group' => esc_html__('Options', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Styling tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Image align', 'wplab-albedo-core-plugin'),
      'param_name' => 'image_align',
      'save_always' => true,
      'value' => array(
        esc_html__('Default', 'wplab-albedo-core-plugin') => '',
        esc_html__('Left', 'wplab-albedo-core-plugin') => 'alignleft',
        esc_html__('Center', 'wplab-albedo-core-plugin') => 'aligncenter',
        esc_html__('Right', 'wplab-albedo-core-plugin') => 'alignright',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate image', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animation',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animation_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation delay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animation_delay',
      'value' => '0.3s',
      'save_always' => true,
      'dependency' => array(
  			'element' => 'animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Image Margins', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'margins',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Image Margins for Mobile Devices', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'margins_mobile',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Image Paddings', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'paddings',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Border color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'border_color',
  		'value' => '',
  		'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  	),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Border style', 'wplab-albedo-core-plugin'),
      'param_name' => 'border_style',
      'save_always' => true,
      'value' => array(
        esc_html__('None', 'wplab-albedo-core-plugin') => 'none',
        esc_html__('Hidden', 'wplab-albedo-core-plugin') => 'hidden',
        esc_html__('Dotted', 'wplab-albedo-core-plugin') => 'dotted',
        esc_html__('Dashed', 'wplab-albedo-core-plugin') => 'dashed',
        esc_html__('Solid', 'wplab-albedo-core-plugin') => 'solid',
        esc_html__('Double', 'wplab-albedo-core-plugin') => 'double',
        esc_html__('Groove', 'wplab-albedo-core-plugin') => 'groove',
        esc_html__('Ridge', 'wplab-albedo-core-plugin') => 'ridge',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Border width', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'border_width',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Border radius', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'border_radius',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Add CSS shadow', 'wplab-albedo-core-plugin' ),
      'param_name' => 'css_shadow',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Shadow color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'shadow_color',
  		'value' => '',
      'dependency' => array(
  			'element' => 'css_shadow',
  			'not_empty' => true,
  		),
  		'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  	),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Position', 'wplab-albedo-core-plugin'),
      'param_name' => 'shadow_type',
      'save_always' => true,
      'value' => array(
        esc_html__('Outside', 'wplab-albedo-core-plugin') => 'outside',
        esc_html__('Inside', 'wplab-albedo-core-plugin') => 'inside',
      ),
      'dependency' => array(
  			'element' => 'css_shadow',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Blur Radius', 'wplab-albedo-core-plugin' ),
      'param_name' => 'shadow_blur_radius',
      'save_always' => true,
      'value' => '0',
      'dependency' => array(
  			'element' => 'css_shadow',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Spread Radius', 'wplab-albedo-core-plugin' ),
      'param_name' => 'shadow_spread_radius',
      'save_always' => true,
      'value' => '0',
      'dependency' => array(
  			'element' => 'css_shadow',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Horizontal Length', 'wplab-albedo-core-plugin' ),
      'param_name' => 'shadow_h_length',
      'save_always' => true,
      'value' => '0',
      'dependency' => array(
  			'element' => 'css_shadow',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Vertical Length', 'wplab-albedo-core-plugin' ),
      'param_name' => 'shadow_v_length',
      'save_always' => true,
      'value' => '0',
      'dependency' => array(
  			'element' => 'css_shadow',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),


  )
));
