<?php

  /**
    * Facts in digits Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Facts_In_Digits extends WPBakeryShortCodesContainer {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;
        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        WPBakeryShortCode_Albedo_Facts_In_Digits_Single::$parent_atts = $_SESSION['albedo_fid_shortcode'] = $atts;

        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . esc_attr( $atts['el_id'] );
        $custom_css = '';

        /** load stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-facts-in-digits', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/facts_in_digits.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/facts_in_digits_variable.less') );
        wp_enqueue_style( 'wplab-albedo-facts-in-digits-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

    		if( $atts['animation_type'] == 'numinate' ) {
    			wp_enqueue_script( 'numinate' );
    		} elseif( $atts['animation_type'] == 'typing' ) {
    			wp_enqueue_script( 'typed' );
    		} elseif( $atts['animation_type'] == 'odometer' ) {
    			wp_enqueue_script( 'odometer' );
    			wp_enqueue_style( 'odometer', get_template_directory_uri() . '/css/libs/odometer.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
    		}

    		/** Custom colors **/

    		if( $atts['icon_color'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' .icon { color: ' . $atts['icon_color'] . '; }';
    			$custom_css .= ' #' . $shortcode_id . ' svg path, #' . $shortcode_id . ' svg rect, #' . $shortcode_id . ' svg polygon, #' . $shortcode_id . ' svg circle { fill: ' . $atts['icon_color'] . '; }';
    		}

    		if( $atts['number_color'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' .number { color: ' . $atts['number_color'] . '; }';
    		}

    		if( $atts['text_color'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' .text { color: ' . $atts['text_color'] . '; }';
    		}

        $attributes[] = 'id="' . $shortcode_id . '"';
        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_facts_in_digits.php';
        return ob_get_clean();

      }

    }
  }
  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Facts_In_Digits_Single extends WPBakeryShortCode {
      public static $parent_atts;
    }
  }
