<?php

  /**
    * Blog Scroll Posts Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Blog_Scroll_Posts extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $wrap_attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/libs/scrollbox.less') );
    		wp_enqueue_style( 'wplab-albedo-scrollbox', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );
    		wp_enqueue_style( 'wplab-albedo-blog-scroll-posts', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/blog_scroll_posts.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/blog_scroll_posts_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-blog-scroll-posts-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'mousewheel' );
    		wp_enqueue_script( 'scrollbox' );
    		wp_enqueue_script( 'wplab-albedo-blog-scroll-posts', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/blog-scroll-posts/static/js/scripts.js'), array('jquery', 'scrollbox'), _WPLAB_ALBEDO_CACHE_TIME_, true );

    		// custom Css
    		if( $atts['custom_radius'] <> '' ) {
    			$radius = absint( $atts['custom_radius'] );
    			$inline_css = ' #' . $shortcode_id . ' { border-radius: ' . $radius . 'px; }';
          $wrap_attributes[] = 'data-custom-css=\'' . $inline_css . '\'';
    		}

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_blog_scroll_posts.php';
        return ob_get_clean();

      }

    }
  }
