<?php

  /**
    * Blog Masonry v2 Media Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Blog_Masonry_V2 extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $wrap_attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** include Masonry Grid **/
        wp_enqueue_script( 'swiper');
    		wp_enqueue_style( 'swiper', get_template_directory_uri() . '/css/libs/swiper.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
    		wp_enqueue_style( 'masonry', get_template_directory_uri() . '/css/libs/masonry.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
    		wp_enqueue_style( 'masonry-effects', get_template_directory_uri() . '/css/libs/masonry_effects.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );

        wp_dequeue_script( 'isotope');
        wp_register_script( 'albedo-isotope', wplab_albedo_utils::locate_uri( '/js/libs/isotope.pkgd.min.js'), array( 'jquery' ), _WPLAB_ALBEDO_CACHE_TIME_, true );
    		wp_enqueue_script( 'albedo-isotope' );

    		wp_enqueue_script( 'anim-on-scroll' );
    		wp_enqueue_script( 'fitvids' );

    		wp_enqueue_style( 'wplab-albedo-blog-masonry-v2', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/blog_masonry_v2.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/blog_masonry_v2_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-blog-masonry-v2-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'wplab-albedo-blog-masonry-v2', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/blog-masonry-v2/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );

        $custom_css = $inline_css = '';

    		// custom styles
    		if( $atts['custom_radius'] <> '' ) {
    			$radius = absint( $atts['custom_radius'] );
    			$inline_css .= ' #' . $shortcode_id . ' .item { border-radius: ' . $radius . 'px; }';
    			$inline_css .= '
    				#' . $shortcode_id . ' .item .post-media img,
    				#' . $shortcode_id . ' .item .post-media iframe,
    				#' . $shortcode_id . ' .item .post-media .overlay {
    							-webkit-border-top-left-radius: ' . $radius . 'px;
    							-webkit-border-top-right-radius: ' . $radius . 'px;
    							-moz-border-radius-topleft: ' . $radius . 'px;
    							-moz-border-radius-topright: ' . $radius . 'px;
    			        border-top-left-radius: ' . $radius . 'px;
    			        border-top-right-radius: ' . $radius . 'px;
    				}';

          $custom_css .= $inline_css;

    		}

        if( $custom_css <> '' ) {
          $wrap_attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_blog_masonry_v2.php';
        return ob_get_clean();

      }

    }
  }
