<?php

  /**
    * Accordion Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Accordion extends WPBakeryShortCodesContainer {

      function __construct( $settings ) {

        parent::__construct( $settings );
        $this->jsCssScripts();
      }

      // Register scripts and styles there (for preview and frontend editor mode).
      public function jsCssScripts() {

        $postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        wp_register_style( 'wplab-albedo-accordion', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/accordion.css' ), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
        wp_register_script( 'wplab-albedo-accordion', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/accordion/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );

      }


    }
  }

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Accordion_Section extends WPBakeryShortCode {
    }
  }
