<?php
  $parent_atts = WPBakeryShortCode_Albedo_Facts_In_Digits_Single::$parent_atts;

  if( is_null( $parent_atts ) ) {
    $parent_atts = $_SESSION['albedo_fid_shortcode'];
  }
  $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

?>


<div class="item
  <?php echo $atts['icon_type'] == '' ? 'no-icon' : ''; ?>
  <?php if( $parent_atts['animate_on_display'] ): ?>wow <?php echo esc_attr( $parent_atts['animation'] ); endif; ?>"
  <?php if( $parent_atts['animate_on_display'] ): ?>data-wow-delay="<?php echo esc_attr( $atts['animation_delay'] ); ?>s"<?php endif; ?>>
  <div class="item-inside">

    <?php if( $atts['icon_type'] == 'fontawesome' ): ?>
    <?php wp_enqueue_style( 'font-awesome' ); ?>
    <div class="icon">
      <i class="<?php echo esc_attr( $atts['icon_font'] ); ?>"></i>
    </div>

    <?php elseif( $atts['icon_type'] == 'custom' ): ?>

    <div class="icon">
      <?php wplab_albedo_media::image_src( $atts['icon_image'] ); ?>
    </div>

    <?php endif; ?>

    <div class="item-text">

      <?php
        $animation_class = '';
        if( $parent_atts['animation_type'] == 'numinate' ) {
          $animation_class = 'animationNuminate';
        } elseif( $parent_atts['animation_type'] == 'typing' ) {
          $animation_class = 'typed';
        } else {
          $animation_class = esc_attr( $parent_atts['animation_type'] );
        }
      ?>

      <?php if( $atts['number'] <> '' ): ?>

        <?php if( $parent_atts['animation_type'] == 'numinate' || $parent_atts['animation_type'] == 'odometer' ): ?>
        <div class="number wow <?php echo $animation_class; ?>" data-to="<?php echo absint( $atts['number'] ); ?>">0</div>
        <?php endif; ?>

        <?php if( $parent_atts['animation_type'] == 'typing' ): ?>
        <div class="number wow <?php echo $animation_class; ?>" data-typed-speed="<?php echo absint( $parent_atts['typing_speed'] ); ?>" data-typed-delay="<?php echo absint( $parent_atts['typing_delay'] ); ?>"><?php echo absint( $atts['number'] ); ?></div>
        <?php endif; ?>

      <?php endif; ?>

      <?php if( $atts['text'] <> '' ): ?>
      <div class="text"><?php echo $atts['text']; ?></div>
      <?php endif; ?>

    </div>

  </div>
</div>
