<?php
  $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

  $attributes[] = 'id="field_' . esc_attr( $atts['el_id'] ) . '"';
  $attributes[] = 'name="field_' . esc_attr( $atts['el_id'] ) . '"';
  $attributes[] = 'value="' . esc_attr( $atts['default_value'] ) . '"';
  $attributes[] = 'placeholder="' . esc_attr( $atts['placeholder'] ) . '"';
  $attributes[] = 'min="' . esc_attr( $atts['restriction_min'] ) . '"';
  $attributes[] = 'max="' . esc_attr( $atts['restriction_max'] ) . '"';

  $attributes[] = 'data-validation="number"';
  if( filter_var( $atts['required'], FILTER_VALIDATE_BOOLEAN ) ) {
    $attributes[] = 'required="required"';
  }

?>
<div class="form-builder-item">
  <div class="field-number">
    <?php if( $atts['label'] <> '' ): ?>
      <label for="field_<?php echo esc_attr( $atts['el_id'] ); ?>"><?php echo wp_kses_post( $atts['label'] ); ?></label>
    <?php endif; ?>

    <input type="hidden" name="field_<?php echo esc_attr( $atts['el_id'] ); ?>_f_label" value="<?php echo esc_attr( $atts['label'] ); ?>" />

    <input type="number" <?php echo implode( ' ', $attributes ); ?> />

    <?php if( $atts['description'] <> '' ): ?>
    <p class="instructions">
      <em><?php echo wp_kses_post( $atts['description'] ); ?></em>
    </p>
    <?php endif; ?>

  </div>
</div>
