<?php
	global $wplab_albedo_core;
	$id = esc_attr( $atts['el_id'] );
	$attributes[] = 'id="shortcode-' . $id . '"';
	$attributes[] = 'data-effect="' . esc_attr( $atts['effect'] ) . '"';
	$attributes[] = 'data-pagination="' . esc_attr( $atts['pagination'] ) . '"';
	$attributes[] = 'data-loop="' . esc_attr( $atts['loop'] ) . '"';

	$attributes[] = 'data-slides-num="' . absint( $atts['items_big'] ) . '"';
	$attributes[] = 'data-slides-medium-num="' . absint( $atts['items_medium'] ) . '"';
	$attributes[] = 'data-slides-small-num="' . absint( $atts['items_small'] ) . '"';

	$attributes[] = 'data-initial-slide="' . absint( $atts['initial_slide'] ) . '"';

	if( filter_var( $atts['autoplay'], FILTER_VALIDATE_BOOLEAN ) ) {
		$attributes[] = 'data-autoplay="' . esc_attr( $atts['autoplay_speed'] ) . '"';
		$attributes[] = 'data-autoplay-stop-on-last="' . esc_attr( $atts['autoplay_stop_on_last'] ) . '"';
		$attributes[] = 'data-autoplay-disable-on-interaction="' . esc_attr( $atts['autoplay_disable_on_interaction'] ) . '"';
	}

	$terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

  $items = $wplab_albedo_core->model('post')->get( array(
    'post_type' => 'benefits',
    'type' => $atts['query_type'],
    'posts_per_page' => absint( $atts['posts_per_page'] ),
    'order' => $atts['order_by'],
    'sort' => $atts['sort_by'],
    'tax_name' => 'benefits_category',
    'term_field' => 'slug',
    'terms' => $terms
  ) );

?>
<div class="shortcode-benefits-carousel <?php echo implode(' ', $classes); ?>" <?php echo implode( ' ', $attributes ); ?>>
	<!-- Slider main container -->
	<div class="swiper-container">

    <!-- Additional required wrapper -->
    <div class="swiper-wrapper">
			<?php while ( $items->have_posts() ): $items->the_post(); ?>

				<?php
					$icon_src = fw_get_db_post_option( get_the_ID(), 'icon' );
					$icon_type = $icon_src['type'];
					$no_icon = ($icon_type == 'icon-font' && empty( $icon_src['pack-name'] ) ) || ($icon_type == 'custom-upload' && empty( $icon_src['url'] ) );
					$link = fw_get_db_post_option( get_the_ID(), 'link' );
					$title = get_the_title();
					$text = get_the_excerpt();
				?>

			<div class="swiper-slide <?php echo $no_icon ? 'no-icon' : ''; ?>">
			  <div class="slide-inside">
			    <div class="icon-box">
						<?php if( $icon_type == 'icon-font' ): wp_enqueue_style( 'font-awesome' ); ?>

						<div class="icon">
						  <i class="<?php echo esc_attr( $icon_src['icon-class'] ); ?>"></i>
						</div>

						<?php elseif( $icon_type == 'custom-upload' ): ?>

						<div class="icon">
						  <?php wplab_albedo_media::image_src( $icon_src['attachment-id'] ); ?>
						</div>

						<?php endif; ?>
			    </div>

			    <div class="benefit-text">
						<?php if( $link <> '' ): ?>
					  <a target="<?php if( filter_var( $atts['link_target'], FILTER_VALIDATE_BOOLEAN ) ): ?>_blank<?php endif; ?>" href="<?php echo esc_attr( $link ); ?>">
					  <?php endif; ?>

					  <?php if( $title <> '' ): ?>
					  <h4><?php echo str_replace("<br /><br />", '<br />', nl2br( $title ) ); ?></h4>
					  <?php endif; ?>

					  <?php if( $link <> '' ): ?>
					  </a>
					  <?php endif; ?>

						<?php if( $text <> '' ): ?>
					  <div class="desc"><?php echo wp_kses_post( $text ); ?></div>
					  <?php endif; ?>

			    </div>
			  </div>
			</div>
			<?php endwhile; wp_reset_postdata(); ?>
    </div>

 </div>

	<?php if( filter_var( $atts['pagination'], FILTER_VALIDATE_BOOLEAN ) ): ?>
  <!-- If we need pagination -->
  <div class="swiper-pagination"></div>
  <?php endif; ?>

</div>
