(function($){

	"use strict";

	// Tabs shortcode
	window.albedo_iconic_tabs_init = function() {

		$('.theme-iconic-tabs').each( function() {
			var $elem = $(this),
			$tabs = $elem.find('.tab_content');

			$elem.find('.tab_content').hide();
			$elem.find('.tab_content:first').show();
			$elem.find('.tab_content:first').addClass('open');

			$elem.find('nav').remove();
      $elem.prepend( '<nav></nav>');
      $tabs.each( function( index ){

        var $tabElem = $(this),
        tabIcon = $tabElem.data('icon'),
				title = $tabElem.data('title'),
				tabIconType = $tabElem.data('icon-type'),
				animation = $tabElem.data('animation-hover') == 'yes' ? 'animate-on-hover' : '',
				animationClass = $tabElem.data('animation-class');

        $tabElem.attr('class',
         function(i, c){
            return c.replace(/(^|\s)tab_number_\S+/g, '');
         });

        $tabElem.addClass('tab_number_' + index )

				var navContent = '<a href="javascript:;" class="a-tab-desktop" data-item="' + index + '">';

				if( tabIconType == 'fontawesome' ) {
					navContent += '<div class="tab-icon ' + animation + '" data-hover-animation="' + animationClass + '"><i class="' + tabIcon + '"></i></div>';
				} else {
					navContent += '<div class="tab-icon ' + animation + '" data-hover-animation="' + animationClass + '"><img class="image-svg" src="' + tabIcon + '" alt="" /></div>';
				}

				navContent += '<span class="title">' + title + '</span>';
				navContent += '</a>';

        $elem.find('nav').append( navContent );

      } );

			$elem.find('nav a.a-tab-desktop:first').addClass('open');

			$elem.find('nav a.a-tab-desktop').on('click', function() {

				var tabNum = $(this).data('item');
				$elem.find('nav a.a-tab-desktop, .tab_content').removeClass('open');
				$(this).addClass('open');
				$elem.find('.tab_content').hide();

				var $content = $elem.find( '.tab_number_' + tabNum );
				if( $content.is(':visible') == false ) {
					$content.addClass('opened').fadeIn();
				}

				if( $(window).width() <= 767 ) {
			    $('html, body').animate({
		        scrollTop: $elem.find('.tabs').offset().top - 20
			    }, 300);
				}

			});

			$elem.find('nav a.a-tab-desktop').hover( function() {
				var $icon = $(this).find('.animate-on-hover'),
				animationClass = $icon.data('hover-animation');

				$icon.removeClass('animated').removeClass( animationClass );
				$icon.filter(':not(:animated)').addClass( animationClass + ' animated' );

			}, function() {
				var $icon = $(this).find('.animate-on-hover'),
				animationClass = $icon.data('hover-animation');

				$icon.off('webkitAnimationEnd oanimationend oAnimationEnd msAnimationEnd animationend').on('webkitAnimationEnd oanimationend oAnimationEnd msAnimationEnd animationend', function() {
					$icon.removeClass( animationClass ).removeClass('animated');
				});

			});

		});
	}

	window.albedo_iconic_tabs_resize = function() {
		$('.theme-iconic-tabs').each( function() {
			var $elem = $(this),
			responsiveBreak = $elem.data('responsive-break');

			responsiveBreak = responsiveBreak == '' ? 767 : responsiveBreak;

			if( $(window).width() < responsiveBreak ) {
				$elem.addClass('mobile');
			} else {
				$elem.removeClass('mobile');
			}

		});
	}

	// Tabs shortcode
	window.albedo_iconic_tabs_init();
	window.albedo_iconic_tabs_resize();

	$(window).resize( function() {
		window.albedo_iconic_tabs_resize();
	});

})( window.jQuery );
