<?php

vc_map( array(
  'name' => esc_html__( 'SVG Icon', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_svg_icon',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/svg-icon.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/svg-icon/js/vc.js',
	'category' => esc_html__( 'Media', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add SVG icon with Lightbox', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  Icon tab
    **/
    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Choose SVG Icon', 'wplab-albedo-core-plugin'),
      'description' => esc_html__('Either upload a new, or choose an existing icon from your media library', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon',
      'group' => esc_html__('Icon', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Width', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set icon width', 'wplab-albedo-core-plugin' ),
      'param_name' => 'width',
      'value' => '',
      'group' => esc_html__('Icon', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Height', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set icon height', 'wplab-albedo-core-plugin' ),
      'param_name' => 'height',
      'value' => '',
      'group' => esc_html__('Icon', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Skip current section to next on click', 'wplab-albedo-core-plugin' ),
      'param_name' => 'skip_section',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Icon', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Link', 'wplab-albedo-core-plugin' ),
      'param_name' => 'link',
      'value' => '',
      'group' => esc_html__('Icon', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Open link in lightbox', 'wplab-albedo-core-plugin' ),
      'param_name' => 'is_lightbox',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Icon', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('Icon', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Styling tab
    **/
    array(
      'type' => 'colorpicker',
      'heading' => esc_html__( 'Icon Color', 'wplab-albedo-core-plugin' ),
      'param_name' => 'color',
      'value' => '',
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Icon align', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon_align',
      'value' => array(
        esc_html__('Default', 'wplab-albedo-core-plugin') => '',
        esc_html__('Left', 'wplab-albedo-core-plugin') => 'alignleft',
        esc_html__('Center', 'wplab-albedo-core-plugin') => 'aligncenter',
        esc_html__('Right', 'wplab-albedo-core-plugin') => 'alignright',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate icon', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animation',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animation_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation delay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animation_delay',
      'save_always' => true,
      'value' => '0.3s',
      'dependency' => array(
  			'element' => 'animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Margins', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'margins',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),

  )
));
