<?php

vc_map( array(
  'name' => esc_html__( 'Heading', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_heading',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/heading.png',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add a heading', 'wplab-albedo-core-plugin' ),
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/special-heading/js/vc.js',
	'params' => array(

		/**
     *  Header attributes tab
    **/
		array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Heading Title', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Write the heading title content. You can use color tags to display text with different colors, e.g.: This text becomes {color-green}green{/color-green}.', 'wplab-albedo-core-plugin' ),
      'param_name' => 'title',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('Header Attributes', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'dropdown',
      'heading' => esc_html__('Heading Size', 'wplab-albedo-core-plugin'),
      'param_name' => 'heading',
      'admin_label' => true,
      'save_always' => true,
      'value' => array(
        'H1' => 'h1',
        'H2' => 'h2',
				'H3' => 'h3',
				'H4' => 'h4',
				'H5' => 'h5',
				'H6' => 'h6',
      ),
      'group' => esc_html__('Header Attributes', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Hide line breaks on mobiles', 'wplab-albedo-core-plugin' ),
			'description' => esc_html__( 'This option hides BR tag inside header on mobile', 'wplab-albedo-core-plugin' ),
      'param_name' => 'disable_br',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Header Attributes', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Custom CSS classes', 'wplab-albedo-core-plugin' ),
			'description' => esc_html__( 'Type here your own custom CSS classes', 'wplab-albedo-core-plugin' ),
      'param_name' => 'custom_classes',
      'value' => '',
      'group' => esc_html__('Header Attributes', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('Header Attributes', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

		/**
     *  Styling tab
    **/
		array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Header text color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'header_color',
  		'value' => '',
  		'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  	),
		array(
      'type' => 'dropdown',
      'heading' => esc_html__('Text Align', 'wplab-albedo-core-plugin'),
      'param_name' => 'text_align',
      'value' => array(
        esc_html__('- Default -', 'wplab-albedo-core-plugin') => '',
        esc_html__('Left', 'wplab-albedo-core-plugin') => 'left',
				esc_html__('Center', 'wplab-albedo-core-plugin') => 'center',
				esc_html__('Right', 'wplab-albedo-core-plugin') => 'right',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'dropdown',
      'heading' => esc_html__('Text Transform', 'wplab-albedo-core-plugin'),
      'param_name' => 'text_transform',
      'value' => array(
        esc_html__('- Default -', 'wplab-albedo-core-plugin') => '',
        esc_html__('None', 'wplab-albedo-core-plugin') => 'none',
				esc_html__('Uppercase', 'wplab-albedo-core-plugin') => 'uppercase',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'dropdown',
      'heading' => esc_html__('Font Style', 'wplab-albedo-core-plugin'),
      'param_name' => 'font_style',
      'value' => array(
        esc_html__('- Default -', 'wplab-albedo-core-plugin') => '',
        esc_html__('Normal', 'wplab-albedo-core-plugin') => 'normal',
				esc_html__('Italic', 'wplab-albedo-core-plugin') => 'italic',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'dropdown',
      'heading' => esc_html__('Font Variant', 'wplab-albedo-core-plugin'),
      'param_name' => 'font_variant',
      'value' => array(
        esc_html__('- Default -', 'wplab-albedo-core-plugin') => '',
        esc_html__('Normal', 'wplab-albedo-core-plugin') => 'normal',
				esc_html__('Small Caps', 'wplab-albedo-core-plugin') => 'small-caps',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'dropdown',
      'heading' => esc_html__('Font Weight', 'wplab-albedo-core-plugin'),
      'param_name' => 'font_weight',
      'value' => array(
        esc_html__('- Default -', 'wplab-albedo-core-plugin') => '',
        esc_html__('Light', 'wplab-albedo-core-plugin') => 'lighter',
				esc_html__('Normal', 'wplab-albedo-core-plugin') => 'normal',
				esc_html__('Bold', 'wplab-albedo-core-plugin') => 'bold',
				esc_html__('Bolder', 'wplab-albedo-core-plugin') => 'bolder',
				'800' => '800',
				'600' => '600',
				'400' => '400',
				'300' => '300',
				'100' => '100',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Font size', 'wplab-albedo-core-plugin' ),
			'description' => esc_html__( 'In pixels, for example: 18', 'wplab-albedo-core-plugin' ),
      'param_name' => 'font_size',
      'value' => '',
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Line height', 'wplab-albedo-core-plugin' ),
			'description' => esc_html__( 'In pixels, for example: 24', 'wplab-albedo-core-plugin' ),
      'param_name' => 'line_height',
      'value' => '',
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Font size (mobile devices)', 'wplab-albedo-core-plugin' ),
			'description' => esc_html__( 'In pixels, for example: 18', 'wplab-albedo-core-plugin' ),
      'param_name' => 'font_size_mobile',
      'value' => '',
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Line height (mobile devices)', 'wplab-albedo-core-plugin' ),
			'description' => esc_html__( 'In pixels, for example: 24', 'wplab-albedo-core-plugin' ),
      'param_name' => 'line_height_mobile',
      'value' => '',
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Letter spacing', 'wplab-albedo-core-plugin' ),
			'description' => esc_html__( 'In pixels, for example: 1', 'wplab-albedo-core-plugin' ),
      'param_name' => 'letter_spacing',
      'value' => '',
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Custom font family', 'wplab-albedo-core-plugin' ),
      'param_name' => 'custom_font_family',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
			'type' => 'google_fonts',
			'param_name' => 'google_fonts',
			'value' => '',
      'dependency' => array(
  			'element' => 'custom_font_family',
  			'not_empty' => true,
  		),
			'settings' => array(
				'fields' => array(
					'font_family_description' => __( 'Select font family.', 'wplab-albedo-core-plugin' ),
					'font_style_description' => __( 'Select font styling.', 'wplab-albedo-core-plugin' ),
				),
			),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
		),
		array(
			'type' => 'albedo_sides_box',
			'heading' => esc_html__( 'Margins', 'wplab-albedo-core-plugin' ),
			'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
			'param_name' => 'margins',
			'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
		array(
			'type' => 'albedo_sides_box',
			'heading' => esc_html__( 'Paddings', 'wplab-albedo-core-plugin' ),
			'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
			'param_name' => 'paddings',
			'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Custom CSS code', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'this code will be applied only for current element', 'wplab-albedo-core-plugin' ),
      'param_name' => 'custom_css',
      'value' => '',
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),

		/**
     *  Animation tab
    **/
		array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'CSS Animation', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animation',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animation_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation delay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animation_delay',
      'save_always' => true,
      'value' => '0.2s',
      'dependency' => array(
  			'element' => 'animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Typed animation', 'wplab-albedo-core-plugin' ),
      'param_name' => 'typed_animation',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation delay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'typed_delay',
      'save_always' => true,
      'value' => '150',
      'dependency' => array(
  			'element' => 'typed_animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation speed', 'wplab-albedo-core-plugin' ),
      'param_name' => 'typed_speed',
      'save_always' => true,
      'value' => '100',
      'dependency' => array(
  			'element' => 'typed_animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),


	)
));
