<?php

  /**
    * Simple Polls Shortcode
  **/

  vc_map( array(
    'name' => esc_html__( 'MailChimp Form', 'wplab-albedo-core-plugin' ),
  	'base' => 'albedo_mailchimp',
    'icon' => $this->plugin_uri . '/assets/shortcode_icons/mailchimp.png',
    'front_enqueue_js' => $this->plugin_uri . '/shortcodes/plugins-mailchimp/js/vc.js',
  	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
  	'description' => esc_html__( 'Add MailChimp Form', 'wplab-albedo-core-plugin' ),
  	'params' => array(

      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Mail Chimp Form ID', 'wplab-albedo-core-plugin' ),
        'description' => esc_html__( 'Type here an ID of Mail Chimp Form to display it.', 'wplab-albedo-core-plugin' ),
        'param_name' => 'form_id',
        'value' => '',
      ),

    )
  ));

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Mailchimp extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;
        
        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/plugins/mailchimp.less') );
        wp_enqueue_style(
      		'wplab-albedo-mailchimp',
      		$variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_
      	);

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_mailchimp.php';
        return ob_get_clean();

      }

    }
  }
