<?php

vc_map( array(
  'name' => esc_html__( 'Justified Photos Grid', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_portfolio_justified_photos_grid',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/justified-photos-grid.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/photo-grid/js/vc.js',
	'category' => esc_html__( 'Portfolio', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add justified photos grid', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  Query tab
    **/

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Posts per page', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'value' => '10',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Posts ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Posts sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query from category', 'wplab-albedo-core-plugin'),
      'param_name' => 'tax_query_type',
      'value' => array(
        esc_html__('All', 'wplab-albedo-core-plugin') => '',
        esc_html__('Only', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Except', 'wplab-albedo-core-plugin') => 'except',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Type here category slugs to include or exclude, based on previous parameter. Explode multiple categories slugs by comma', 'wplab-albedo-core-plugin' ),
      'param_name' => 'tax_query_terms',
      'value' => '',
      'dependency' => array(
  			'element' => 'tax_query_type',
  			'value' => array( 'only', 'except' ),
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Featured posts only', 'wplab-albedo-core-plugin' ),
      'param_name' => 'featured_only',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Grid tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Row height', 'wplab-albedo-core-plugin' ),
      'param_name' => 'row_height',
      'value' => '260',
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Maximum row height', 'wplab-albedo-core-plugin' ),
      'param_name' => 'max_row_height',
      'value' => '300',
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Margins between images', 'wplab-albedo-core-plugin' ),
      'param_name' => 'margins',
      'value' => '0',
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Randomize photos on load', 'wplab-albedo-core-plugin' ),
      'param_name' => 'randomize',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Custom overlay color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'overlay_color',
  		'value' => '',
  		'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
  	),
	),
));
