<?php

vc_map( array(
  'name' => esc_html__( 'Full Screen Photos', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_portfolio_full_screen_photos',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/fullscreen-photos.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/photo-fullscreen/js/vc.js',
	'category' => esc_html__( 'Portfolio', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add Full-Screen Photos Shortcode', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  Query tab
    **/

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Posts per page', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'value' => '10',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Posts ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Posts sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query from category', 'wplab-albedo-core-plugin'),
      'param_name' => 'tax_query_type',
      'value' => array(
        esc_html__('All', 'wplab-albedo-core-plugin') => '',
        esc_html__('Only', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Except', 'wplab-albedo-core-plugin') => 'except',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Type here category slugs to include or exclude, based on previous parameter. Explode multiple categories slugs by comma', 'wplab-albedo-core-plugin' ),
      'param_name' => 'tax_query_terms',
      'value' => '',
      'dependency' => array(
  			'element' => 'tax_query_type',
  			'value' => array( 'only', 'except' ),
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Featured posts only', 'wplab-albedo-core-plugin' ),
      'param_name' => 'featured_only',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Style tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'effect',
      'value' => array(
        esc_html__('Brush', 'wplab-albedo-core-plugin') => 'brush',
        esc_html__('Fall', 'wplab-albedo-core-plugin') => 'fall',
        esc_html__('Water', 'wplab-albedo-core-plugin') => 'water',
        esc_html__('Urban', 'wplab-albedo-core-plugin') => 'urban',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Autoplay time', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_time',
      'value' => '5000',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Slide time', 'wplab-albedo-core-plugin' ),
      'param_name' => 'slide_time',
      'value' => '1400',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display pagination', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_pagination',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display arrows', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_arrows',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Arrows style', 'wplab-albedo-core-plugin'),
      'param_name' => 'arrows_style',
      'value' => array(
        esc_html__('Side', 'wplab-albedo-core-plugin') => 'side',
        esc_html__('Prev / next', 'wplab-albedo-core-plugin') => 'prev_next',
        esc_html__('Thumbnails', 'wplab-albedo-core-plugin') => 'thumbs',
      ),
      'dependency' => array(
  			'element' => 'display_arrows',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_title',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Title position', 'wplab-albedo-core-plugin'),
      'param_name' => 'title_position',
      'value' => array(
        esc_html__('Vertical', 'wplab-albedo-core-plugin') => 'vertical',
        esc_html__('Horizontal', 'wplab-albedo-core-plugin') => 'horizontal',
      ),
      'dependency' => array(
  			'element' => 'display_title',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display description', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_desc',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post author', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_author',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Custom overlay color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'overlay_color',
  		'value' => '',
  		'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
  	),
	),
));
