(function ( $ ) {

	function wplab_albedo_video_lightbox_refresh( element ) {

    var $iframe = $("#vc_inline-frame"),
		contentWindow = $iframe[0].contentWindow,
		iframeContents = $iframe.contents(),
		$element = element.$el.find('.video-shortcode-wrapper'),
		elementId = $element.attr('id'),
		cssId = 'albedo-custom-css-id-' + elementId;

		iframeContents.find('#' + cssId).remove();
		iframeContents.find("head").append('<!-- auto generated custom css by element / shortcode --><style type="text/css" id="' + cssId + '">' + $element.data('custom-css') + '</style>');

		if( 'albedo_video_lightbox_init' in contentWindow ) {
			contentWindow.themeFrontCore.initLazyLoading();
			contentWindow.albedo_video_lightbox_init();
		} else {
			setTimeout( function() {
				contentWindow.themeFrontCore.initLazyLoading();
				contentWindow.albedo_video_lightbox_init();
			}, 500 );
		}

	}

	window.InlineShortcodeView_albedo_video_lightbox = window.InlineShortcodeView.extend({
		render: function () {

			window.InlineShortcodeView_albedo_video_lightbox.__super__.render.call( this );
			wplab_albedo_video_lightbox_refresh( this );

		  return this;
		},
		updated: function() {
			_.each(vc.shortcodes.where({
					parent_id: this.model.get("id")
			}), function(model) {
					model.view.parent_view = this, model.view.parentChanged()
			}, this), _.defer(_.bind(function() {
					vc.events.trigger("shortcodeView:updated", this.model), vc.events.trigger("shortcodeView:updated:" + this.model.get("shortcode"), this.model), vc.events.trigger("shortcodeView:updated:" + this.model.get("id"), this.model)
			}, this))

			// wait until element will be fully loaded
			var instance = this;
	    $(document).ajaxStop(function () {
				wplab_albedo_video_lightbox_refresh( instance );
			});

		}
	});

})( window.jQuery );
