<?php

vc_map( array(
  'name' => esc_html__( 'Masonry image gallery', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_masonry_images_gallery',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/justified-image-gallery.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/media-masonry-images/js/vc.js',
	'category' => esc_html__( 'Media', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add masonry images grid', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  General tab
    **/
    array(
      'type' => 'attach_images',
      'heading' => esc_html__('Choose images', 'wplab-albedo-core-plugin'),
      'param_name' => 'images',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Grid tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Columns', 'wplab-albedo-core-plugin'),
      'param_name' => 'cols',
      'save_always' => true,
      'value' => array(
        '6' => '6',
        '5' => '5',
        '4' => '4',
        '3' => '3',
        '2' => '2',
        '1' => '1',
      ),
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Loading effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'effect',
      'save_always' => true,
      'value' => array(
        esc_html__('Fade', 'wplab-albedo-core-plugin') => 'effect-1',
        esc_html__('Move Up', 'wplab-albedo-core-plugin') => 'effect-2',
        esc_html__('Scale up', 'wplab-albedo-core-plugin') => 'effect-3',
        esc_html__('Fall perspective', 'wplab-albedo-core-plugin') => 'effect-4',
        esc_html__('Fly', 'wplab-albedo-core-plugin') => 'effect-5',
        esc_html__('Calendar', 'wplab-albedo-core-plugin') => 'effect-6',
        esc_html__('Helix', 'wplab-albedo-core-plugin') => 'effect-7',
        esc_html__('Flip', 'wplab-albedo-core-plugin') => 'effect-8',
      ),
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Margins between images', 'wplab-albedo-core-plugin' ),
      'param_name' => 'margins',
      'save_always' => true,
      'value' => '40',
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display image caption', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_caption',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),


    /**
     *  Style tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Border radius for images', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 20. This option may not work if you are using hover effects', 'wplab-albedo-core-plugin' ),
      'param_name' => 'border_radius',
      'value' => '',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Overlay color', 'wplab-albedo-core-plugin'),
      'param_name' => 'overlay_color',
      'save_always' => true,
      'value' => array(
        esc_html__('Dark', 'wplab-albedo-core-plugin') => 'dark',
        esc_html__('Theme Accent', 'wplab-albedo-core-plugin') => 'accent',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Add shadows', 'wplab-albedo-core-plugin' ),
      'param_name' => 'shadows',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),

  )
));
