<?php

vc_map( array(
  'name' => esc_html__( 'Facts in digits', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_facts_in_digits',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/facts-in-digits.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/facts-in-digits/js/vc.js',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add counters shortcode', 'wplab-albedo-core-plugin' ),
  'as_parent' => array( 'only' => 'albedo_facts_in_digits_single,vc_column,vc_row' ),
  'content_element' => true,
  'is_container' => true,
  'show_settings_on_create' => true,
  'js_view' => is_admin() ? 'VcColumnView' : '',
	'params' => array(

    /**
     * General tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation style', 'wplab-albedo-core-plugin'),
      'param_name' => 'animation_type',
      'save_always' => true,
      'value' => array(
        esc_html__('Numinate', 'wplab-albedo-core-plugin') => 'numinate',
        esc_html__('Typing', 'wplab-albedo-core-plugin') => 'typing',
        esc_html__('Odometer', 'wplab-albedo-core-plugin') => 'odometer',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Typing speed', 'wplab-albedo-core-plugin' ),
      'param_name' => 'typing_speed',
      'value' => '100',
      'save_always' => true,
      'dependency' => array(
  			'element' => 'animation_type',
  			'value' => array( 'typing' ),
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Typing delay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'typing_delay',
      'save_always' => true,
      'value' => '100',
      'dependency' => array(
  			'element' => 'animation_type',
  			'value' => array( 'typing' ),
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     * Animation tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate elements on display', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_display',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animate_on_display_effect',
      'value' => $this->cfg['animations'],
      'save_always' => true,
      'dependency' => array(
  			'element' => 'animate_on_display',
  			'not_empty' => true,
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),

    /**
     * Custom colors tab
    **/
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Icon color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'icon_color',
  		'value' => '',
  		'group' => esc_html__('Custom colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Number color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'number_color',
  		'value' => '',
  		'group' => esc_html__('Custom colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Text color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'text_color',
  		'value' => '',
  		'group' => esc_html__('Custom colors', 'wplab-albedo-core-plugin'),
  	),

  )
));

vc_map( array(
  'name' => esc_html__( 'Counter', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_facts_in_digits_single',
  'content_element' => true,
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/facts-in-digits.png',
  'as_child' => array( 'only' => 'albedo_facts_in_digits,vc_column_inner' ),
	'params' => array(

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Number', 'wplab-albedo-core-plugin' ),
      'param_name' => 'number',
      'admin_label' => true,
      'value' => '',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Description', 'wplab-albedo-core-plugin' ),
      'param_name' => 'text',
      'admin_label' => true,
      'value' => '',
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Benefit icon', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon_type',
      'save_always' => true,
      'value' => array(
        esc_html__('Without Icon', 'wplab-albedo-core-plugin') => '',
        esc_html__('Choose an icon from Icon Library', 'wplab-albedo-core-plugin') => 'fontawesome',
        esc_html__('Upload custom Image icon', 'wplab-albedo-core-plugin') => 'custom',
      ),
    ),
    array(
      'type' => 'iconpicker',
      'heading' => esc_html__('Icon', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon_font',
      'save_always' => true,
      'dependency' => array(
  			'element' => 'icon_type',
  			'value' => array( 'fontawesome' ),
  		),
      'settings' => array(
        'emptyIcon' => true,
        'type' => 'fontawesome',
      )
    ),
    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Upload icon', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon_image',
      'dependency' => array(
  			'element' => 'icon_type',
  			'value' => array( 'custom' ),
  		),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation delay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animation_delay',
      'value' => '0.2',
      'save_always' => true,
    ),

  )
));
