<?php

vc_map( array(
  'name' => esc_html__( 'URL', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_contact_form_url',
  'content_element' => true,
  'category' => esc_html__( 'Form Fields', 'wplab-albedo-core-plugin' ),
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/website.png',
  'as_child' => array( 'only' => 'albedo_contact_form,vc_column_inner' ),
	'params' => array(

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Label', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Enter field label (it will be displayed on the web site)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'label',
      'admin_label' => true,
      'value' => '',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Placeholder', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'This text will be used as field placeholder', 'wplab-albedo-core-plugin' ),
      'param_name' => 'placeholder',
      'value' => '',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Default value', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'This text will be used as field default value', 'wplab-albedo-core-plugin' ),
      'param_name' => 'default_value',
      'value' => '',
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Mandatory Field', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__('Make this field mandatory?', 'wplab-albedo-core-plugin'),
      'param_name' => 'required',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Instructions for Users', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'The users will see these instructions in the tooltip near the field', 'wplab-albedo-core-plugin' ),
      'param_name' => 'description',
      'value' => '',
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Field name', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'description' => esc_html__( 'Used in "name" attribute', 'wplab-albedo-core-plugin' ),
    ),

  )
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Albedo_Contact_Form_Url extends WPBakeryShortCode {
  }
}
