<?php

vc_map( array(
  'name' => esc_html__( 'Submit', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_contact_form_submit',
  'content_element' => true,
  'category' => esc_html__( 'Form Fields', 'wplab-albedo-core-plugin' ),
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/button.png',
  'as_child' => array( 'only' => 'albedo_contact_form,vc_column_inner' ),
	'params' => array(

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Label', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'This text will appear in submit button', 'wplab-albedo-core-plugin' ),
      'param_name' => 'submit_button_text',
      'admin_label' => true,
      'value' => esc_html__( 'Send', 'wplab-albedo-core-plugin' ),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Button Style', 'wplab-albedo-core-plugin'),
      'param_name' => 'submit_style',
      'value' => $this->cfg['button_styles'],
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Button Align', 'wplab-albedo-core-plugin'),
      'param_name' => 'align',
      'save_always' => true,
      'value' => array(
        esc_html__('None', 'wplab-albedo-core') => '',
        esc_html__( 'Left', 'wplab-albedo-core' ) => 'left',
        esc_html__( 'Center', 'wplab-albedo-core' ) => 'center',
        esc_html__( 'Right', 'wplab-albedo-core' ) => 'right',
      ),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Button Size', 'wplab-albedo-core-plugin'),
      'param_name' => 'size',
      'save_always' => true,
      'value' => array(
        esc_html__( 'Medium', 'wplab-albedo-core' ) => 'medium',
        esc_html__( 'Small', 'wplab-albedo-core' ) => 'small',
        esc_html__( 'Large', 'wplab-albedo-core' ) => 'large',
        esc_html__( 'X Large', 'wplab-albedo-core' ) => 'xlarge',
      ),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Button ID', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Here you can set unique identifier for this button', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'value' => '',
    ),

  )
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Albedo_Contact_Form_Submit extends WPBakeryShortCode {
  }
}
