<?php

vc_map( array(
  'name' => esc_html__( 'Contact Form', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_contact_form',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/contact-form.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/contact-form/js/vc.js',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add contact form', 'wplab-albedo-core-plugin' ),
  'as_parent' => array( 'only' => 'albedo_contact_form_submit,albedo_contact_form_checkbox,albedo_contact_form_dropdown,albedo_contact_form_email,albedo_contact_form_number,albedo_contact_form_radio,albedo_contact_form_recaptcha,albedo_contact_form_text,albedo_contact_form_textarea,albedo_contact_form_url,vc_column_text,albedo_heading,vc_row' ),
  'content_element' => true,
  'is_container' => true,
  'show_settings_on_create' => true,
  'js_view' => is_admin() ? 'VcColumnView' : 'ViewAlbedoContactForm',
	'params' => array(

    /**
     *  Form tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Email To', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'The form will be sent to this email address.', 'wplab-albedo-core-plugin' ),
      'param_name' => 'email_to',
      'admin_label' => true,
      'save_always' => true,
      'value' => get_option( 'admin_email'),
      'group' => esc_html__('Form', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Subject Message', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'This text will be used as subject message for the email', 'wplab-albedo-core-plugin' ),
      'param_name' => 'subject_message',
      'admin_label' => true,
      'value' => esc_html__( 'New message', 'wplab-albedo-core-plugin' ),
      'group' => esc_html__('Form', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('Form', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Style tab
    **/

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Form style', 'wplab-albedo-core-plugin'),
      'description' => esc_html__('can be used to change color scheme', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'admin_label' => true,
      'value' => array(
        esc_html__('White', 'wplab-albedo-core') => 'white',
        esc_html__( 'White, alternate style', 'wplab-albedo-core' ) => 'white_alt',
        esc_html__( 'Dark', 'wplab-albedo-core' ) => 'dark',
        esc_html__( 'Dark, alternate style', 'wplab-albedo-core' ) => 'dark_alt',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Boxed form style', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__('Apply boxed style for a form container', 'wplab-albedo-core-plugin'),
      'param_name' => 'style_boxed',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Box Style', 'wplab-albedo-core-plugin'),
      'description' => esc_html__('Light box style should be used within a Light form style, the same applies to dark styles', 'wplab-albedo-core-plugin'),
      'param_name' => 'box_style',
      'value' => array(
        esc_html__('Light', 'wplab-albedo-core') => 'light',
        esc_html__( 'Dark', 'wplab-albedo-core' ) => 'dark',
      ),
      'dependency' => array(
  			'element' => 'style_boxed',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Inputs Style', 'wplab-albedo-core-plugin'),
      'param_name' => 'inputs_style',
      'value' => array(
        esc_html__('Rounded', 'wplab-albedo-core') => 'rounded',
        esc_html__( 'Square', 'wplab-albedo-core' ) => 'square',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Redirect tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Redirect on success', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Type here any URL where user will be redirected after form submit, e.g. to the Thank You page.', 'wplab-albedo-core-plugin' ),
      'param_name' => 'redirect_on_success',
      'value' => '',
      'group' => esc_html__('Redirect', 'wplab-albedo-core-plugin'),
    ),

    /**
     * Messages tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Success Message', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'This text will be displayed when the form will successfully send', 'wplab-albedo-core-plugin' ),
      'param_name' => 'success_message',
      'value' => esc_html__( 'Message sent!', 'wplab-albedo-core-plugin' ),
      'group' => esc_html__('Messages', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Validation messages language', 'wplab-albedo-core-plugin'),
      'param_name' => 'lang',
      'value' => array(
        esc_html__('English', 'wplab-albedo-core') => 'en',
        esc_html__('Polish', 'wplab-albedo-core') => 'pt',
        esc_html__('Romanian', 'wplab-albedo-core') => 'ro',
        esc_html__('Danish', 'wplab-albedo-core') => 'dk',
        esc_html__('Norwegian', 'wplab-albedo-core') => 'no',
        esc_html__('Dutch', 'wplab-albedo-core') => 'nl',
        esc_html__('Czech', 'wplab-albedo-core') => 'cz',
        esc_html__('Catalan', 'wplab-albedo-core') => 'ca',
        esc_html__('Russian', 'wplab-albedo-core') => 'ru',
        esc_html__('Italian', 'wplab-albedo-core') => 'it',
        esc_html__('French', 'wplab-albedo-core') => 'fr',
        esc_html__('German', 'wplab-albedo-core') => 'de',
        esc_html__('Swedish', 'wplab-albedo-core') => 'se',
        esc_html__('Portuguese', 'wplab-albedo-core') => 'pt',
      ),
      'group' => esc_html__('Messages', 'wplab-albedo-core-plugin'),
    ),

  )
));

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
  class WPBakeryShortCode_Albedo_Contact_Form extends WPBakeryShortCodesContainer {

    function __construct( $settings ) {

      parent::__construct( $settings );

      wp_register_script( 'form-validator', plugin_dir_url( __FILE__ ) . '/js/jquery.form-validator.min.js', array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );
      wp_register_script( 'wplab-albedo-contact-form', plugin_dir_url( __FILE__ ) . '/js/scripts.js', array('form-validator'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );

    }

  }
}

/**
 * Send a message using AJAX
**/

add_action( 'wp_ajax_albedo_contact_form', 'wplab_albedo_ajax_contact_form');
add_action( 'wp_ajax_nopriv_albedo_contact_form', 'wplab_albedo_ajax_contact_form');

function wplab_albedo_ajax_contact_form() {

  $answer = array(
    'result' => 'fail'
  );

  if( ! wp_verify_nonce( $_POST['security'], 'albedo-contact-form' ) ) {
    $answer['error'] = esc_html__( 'Wrong form verification. Please try again.', 'wplab-albedo-core-plugin');
    die( json_encode( $answer ) );
  }

  $form_values = array();
  parse_str( $_POST['form_values'], $form_values );
  $form_data = unserialize( base64_decode( $_POST['form_data'] ) );
  $content = '';

  // Check for anti-spam, if recaptha exists
  $captcha_secret = isset( $_SESSION['albedo_contact_form' . $form_data['form_id'] ]['captcha_secret'] ) ? $_SESSION['albedo_contact_form' . $form_data['form_id'] ]['captcha_secret'] : '';

  // validate captcha
  if( $captcha_secret <> '' ) {
    $captcha_resp = wp_remote_post( 'https://www.google.com/recaptcha/api/siteverify', array(
      'body' => array(
        'secret' => $captcha_secret,
        'response' => $form_values['g-recaptcha-response']
      )
    ));

    if ( is_wp_error( $captcha_resp ) ) {
      $answer['error'] = $captcha_resp->get_error_message();
    } else {
      $verify_responce = json_decode( $captcha_resp['body'] );
      if( ! filter_var( $verify_responce->success, FILTER_VALIDATE_BOOLEAN ) ) {
        $answer['error'] = esc_html__( 'Captcha was not verified, please try again... if you are not a robot, of course!', 'wplab-albedo-core-plugin');
      }
    }

  }

  if( isset( $answer['error'] ) ) {
    die( json_encode( $answer ) );
  }

  // Generate message content
  if( is_array( $form_values ) && count( $form_values ) ) {

    foreach( $form_values as $k => $v ) {
      if (strpos( $k, '_f_label') !== false) {
        $field_id = str_replace( '_f_label', '', $k );

        $content .= "$v: ";

        if( isset( $form_values[$field_id] ) && is_array( $form_values[$field_id] ) ) {
          $content .= implode( ', ', $form_values[$field_id] );
        } else {
          $content .= $form_values[$field_id];
        }

        $content .= "\r\n";

      }
    }

  }

  // Send email
  if( is_email( $form_data['email_to'] ) ) {
    wp_mail( $form_data['email_to'], wp_kses_post( $form_data['subject_message'] ), wp_kses_post( $content ) );
    $answer['result'] = 'ok';
  }

  die( json_encode( $answer ) );
}
