<?php

  /**
    * Colorful Link Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Colorful_Link extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
        $attributes = $classes = array();
        $custom_css = '';
        $shortcode_id = 'shortcode-' . esc_attr( $atts['el_id'] );

        global $wplab_albedo_core_plugin;
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/colorful_link.less') );
        wp_enqueue_style( 'wplab-albedo-shortcode-colorful-link', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        /** unique id **/
      	$attributes[] = 'id="shortcode-' . esc_attr( $atts['el_id'] ) . '"';
      	$attributes[] = 'href="' . esc_attr( $atts['url'] ) . '"';
      	$attributes[] = 'target="' . esc_attr( $atts['target'] ) . '"';
      	$classes[] = 'color-' . esc_attr( $atts['style'] );
      	$classes[] = 'shadow-' . esc_attr( $atts['shadow'] );
      	$classes[] = 'text-align-' . esc_attr( $atts['text_align'] );

    		if( isset( $atts['height'] ) && $atts['height'] <> '' ) {
    			$height = absint( $atts['height'] );
    			$custom_css .= ' #' . $shortcode_id . ' { height: ' . $height . 'px; }';
    		}

    		if( isset( $atts['paddings'] ) && $atts['paddings'] <> '' ) {
    			$paddings = absint( $atts['paddings'] );
    			$custom_css .= ' #' . $shortcode_id . ' { padding: ' . $paddings . 'px; }';
    		}

        $attributes[] = 'id="' . $shortcode_id . '"';
        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_colorful_link.php';
        return ob_get_clean();

      }

    }
  }
