<?php

vc_map( array(
  'name' => esc_html__( 'Colorful Link', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_colorful_link',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/colorful-link.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/colorful-link/js/vc.js',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add colorful link', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  General tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Link URL', 'wplab-albedo-core-plugin' ),
      'param_name' => 'url',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Link text', 'wplab-albedo-core-plugin' ),
      'param_name' => 'text',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Open link at new tab?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'target',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => '_blank' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Styling tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Block height', 'wplab-albedo-core-plugin' ),
      'param_name' => 'height',
      'value' => '',
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Block paddings', 'wplab-albedo-core-plugin' ),
      'param_name' => 'paddings',
      'value' => '',
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Text align', 'wplab-albedo-core-plugin'),
      'param_name' => 'text_align',
      'save_always' => true,
      'value' => array(
        esc_html__('Default', 'wplab-albedo-core-plugin') => 'default',
        esc_html__('Left', 'wplab-albedo-core-plugin') => 'left',
        esc_html__('Center', 'wplab-albedo-core-plugin') => 'center',
        esc_html__('Right', 'wplab-albedo-core-plugin') => 'right',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Box style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'save_always' => true,
      'value' => $this->cfg['base_colors'],
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Add shadow?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'shadow',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),

  )
));
