(function ( $ ) {

	function wplab_albedo_benefits_filters_refresh( element ) {

		var $iframe = $("#vc_inline-frame"),
		iframeContents = $iframe.contents(),
		contentWindow = $iframe[0].contentWindow,
		$element = element.$el.find('.shortcode-benefits'),
		elementId = $element.attr('id'),
		cssId = 'albedo-custom-css-id-' + elementId;

		iframeContents.find('#' + cssId).remove();
		iframeContents.find("head").append('<!-- auto generated custom css by element / shortcode --><style type="text/css" id="' + cssId + '">' + $element.data('custom-css') + '</style>');

		contentWindow.themeFrontCore.initLazyLoading();
		contentWindow.themeFrontCore.loadSVG();

		if( 'albedo_benefits_v2_init' in contentWindow ) {
			contentWindow.albedo_benefits_v2_init();
		} else {
			setTimeout( function() {
				contentWindow.albedo_benefits_v2_init();
			}, 500 );
		}

	}

	window.InlineShortcodeView_albedo_benefits_filters = window.InlineShortcodeView.extend({
		render: function () {

			window.InlineShortcodeView_albedo_benefits_filters.__super__.render.call( this );
			wplab_albedo_benefits_filters_refresh( this );

		  return this;
		},
		updated: function() {
			_.each(vc.shortcodes.where({
					parent_id: this.model.get("id")
			}), function(model) {
					model.view.parent_view = this, model.view.parentChanged()
			}, this), _.defer(_.bind(function() {
					vc.events.trigger("shortcodeView:updated", this.model), vc.events.trigger("shortcodeView:updated:" + this.model.get("shortcode"), this.model), vc.events.trigger("shortcodeView:updated:" + this.model.get("id"), this.model)
			}, this))

			// wait until element will be fully loaded
			var instance = this;
	    $(document).ajaxStop(function () {
				wplab_albedo_benefits_filters_refresh( instance );
			});

		}
	});

})( window.jQuery );
