<?php

vc_map( array(
  'name' => esc_html__( 'Benefits Carousel', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_benefits_carousel',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/benefits-carousel.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/benefits-carousel/js/vc.js',
	'category' => esc_html__( 'Services', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add benefits carousel', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     * General tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query type', 'wplab-albedo-core-plugin'),
      'param_name' => 'query_type',
      'admin_label' => true,
      'value' => array(
        esc_html__('All Benefits', 'wplab-albedo-core-plugin') => 'all',
        esc_html__('Benefits only from selected categories', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Benefits except categories', 'wplab-albedo-core-plugin') => 'except',
        esc_html__('Display child posts from selected category', 'wplab-albedo-core-plugin') => 'all_child',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Benefits count', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'value' => '10',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'param_name' => 'cats',
      'admin_label' => true,
      'value' => '',
      'dependency' => array(
        'element' => 'query_type',
        'value' => array( 'only', 'except' ),
      ),
      'description' => esc_html__( 'Type here categories slugs, e.g. my-category', 'wplab-albedo-core-plugin' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu_order',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     * Carousel Settings tab
    **/

    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Open links at new tab', 'wplab-albedo-core-plugin' ),
      'param_name' => 'link_target',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => '_blank' ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Carousel Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'effect',
      'save_always' => true,
      'value' => array(
        esc_html__('Slide', 'wplab-albedo-core-plugin') => 'slide',
        esc_html__('Fade', 'wplab-albedo-core-plugin') => 'fade',
        esc_html__('Cube', 'wplab-albedo-core-plugin') => 'cube',
        esc_html__('Coverflow', 'wplab-albedo-core-plugin') => 'coverflow',
        esc_html__('Flip', 'wplab-albedo-core-plugin') => 'flip',
      ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Pagination', 'wplab-albedo-core-plugin' ),
      'param_name' => 'pagination',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Autoplay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Autoplay speed', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'in milliseconds, e.g.: 2000 = 2 seconds', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_speed',
      'save_always' => true,
      'value' => '2000',
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Stop on last slide', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Enable this parameter and autoplay will be stopped when it reaches last slide (has no effect in loop mode)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_stop_on_last',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Disable autoplay on iteration', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set to false and autoplay will not be disabled after user interactions, it will be restarted every time after interaction', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_disable_on_interaction',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Loop slider', 'wplab-albedo-core-plugin' ),
      'param_name' => 'loop',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),

    /**
     * Responsive Settings tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Initial slide', 'wplab-albedo-core-plugin' ),
      'param_name' => 'initial_slide',
      'save_always' => true,
      'value' => '0',
      'group' => esc_html__('Responsive Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Visible items (big screen)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'items_big',
      'save_always' => true,
      'value' => '3',
      'group' => esc_html__('Responsive Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Visible items (medium screen)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'items_medium',
      'save_always' => true,
      'value' => '2',
      'group' => esc_html__('Responsive Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Visible items (small screen)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'items_small',
      'save_always' => true,
      'value' => '1',
      'group' => esc_html__('Responsive Settings', 'wplab-albedo-core-plugin'),
    ),

  )
));
